/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicyTreeElement;
import org.jboss.security.xacml.sunxacml.Target;
import org.jboss.security.xacml.sunxacml.attr.BooleanAttribute;
import org.jboss.security.xacml.sunxacml.cond.Apply;
import org.jboss.security.xacml.sunxacml.cond.Condition;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.VariableManager;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule
implements PolicyTreeElement {
    private URI idAttr;
    private int effectAttr;
    private String description = null;
    private Target target = null;
    private Condition condition = null;

    public Rule(URI id, int effect, String description, Target target, Condition condition) {
        this.idAttr = id;
        this.effectAttr = effect;
        this.description = description;
        this.target = target;
        this.condition = condition;
    }

    public Rule(URI id, int effect, String description, Target target, Apply condition) {
        this.idAttr = id;
        this.effectAttr = effect;
        this.description = description;
        this.target = target;
        this.condition = new Condition(condition.getFunction(), condition.getChildren());
    }

    public static Rule getInstance(Node root, String xpathVersion) throws ParsingException {
        return Rule.getInstance(root, new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    public static Rule getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        URI id = null;
        Object name = null;
        int effect = 0;
        String description = null;
        Target target = null;
        Condition condition = null;
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("RuleId").getNodeValue());
        }
        catch (URISyntaxException use) {
            throw new ParsingException("Error parsing required attribute RuleId", use);
        }
        String str = attrs.getNamedItem("Effect").getNodeValue();
        if (str.equals("Permit")) {
            effect = 0;
        } else if (str.equals("Deny")) {
            effect = 1;
        } else {
            throw new ParsingException("Invalid Effect: " + effect);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = child.getNodeName();
            if (cname.equals("Description")) {
                description = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("Target")) {
                target = Target.getInstance(child, metaData);
                continue;
            }
            if (!cname.equals("Condition")) continue;
            condition = Condition.getInstance(child, metaData, manager);
        }
        return new Rule(id, effect, description, target, condition);
    }

    public int getEffect() {
        return this.effectAttr;
    }

    public URI getId() {
        return this.idAttr;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public MatchResult match(EvaluationCtx context) {
        if (this.target == null) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, "no target available for matching a rule");
            return new MatchResult(2, status);
        }
        return this.target.match(context);
    }

    public Result evaluate(EvaluationCtx context) {
        if (this.target != null) {
            MatchResult match = this.target.match(context);
            int result = match.getResult();
            if (result == 1) {
                return new Result(3, context.getResourceId().encode());
            }
            if (result == 2) {
                return new Result(2, match.getStatus(), context.getResourceId().encode());
            }
        }
        if (this.condition == null) {
            return new Result(this.effectAttr, context.getResourceId().encode());
        }
        EvaluationResult result = this.condition.evaluate(context);
        if (result.indeterminate()) {
            return new Result(2, result.getStatus(), context.getResourceId().encode());
        }
        BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
        if (bool.getValue()) {
            return new Result(this.effectAttr, context.getResourceId().encode());
        }
        return new Result(3, context.getResourceId().encode());
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.print(indent + "<Rule RuleId=\"" + this.idAttr.toString() + "\" Effect=\"" + Result.DECISIONS[this.effectAttr] + "\"");
        if (this.description != null || this.target != null || this.condition != null) {
            out.println(">");
            indenter.in();
            String nextIndent = indenter.makeString();
            if (this.description != null) {
                out.println(nextIndent + "<Description>" + this.description + "</Description>");
            }
            if (this.target != null) {
                this.target.encode(output, indenter);
            }
            if (this.condition != null) {
                this.condition.encode(output, indenter);
            }
            indenter.out();
            out.println(indent + "</Rule>");
        } else {
            out.println("/>");
        }
    }
}

