/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Rule;
import org.jboss.security.xacml.sunxacml.combine.RuleCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.RuleCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;

public class DenyOverridesRuleAlg
extends RuleCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public DenyOverridesRuleAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected DenyOverridesRuleAlg(URI identifier) {
        super(identifier);
    }

    public Result combine(EvaluationCtx context, List parameters, List ruleElements) {
        boolean atLeastOneError = false;
        boolean potentialDeny = false;
        boolean atLeastOnePermit = false;
        Result firstIndeterminateResult = null;
        Iterator it = ruleElements.iterator();
        while (it.hasNext()) {
            Rule rule = ((RuleCombinerElement)it.next()).getRule();
            Result result = rule.evaluate(context);
            int value = result.getDecision();
            if (value == 1) {
                return result;
            }
            if (value == 2) {
                atLeastOneError = true;
                if (firstIndeterminateResult == null) {
                    firstIndeterminateResult = result;
                }
                if (rule.getEffect() != 1) continue;
                potentialDeny = true;
                continue;
            }
            if (value != 0) continue;
            atLeastOnePermit = true;
        }
        if (potentialDeny) {
            return firstIndeterminateResult;
        }
        if (atLeastOnePermit) {
            return new Result(0, context.getResourceId().encode());
        }
        if (atLeastOneError) {
            return firstIndeterminateResult;
        }
        return new Result(3, context.getResourceId().encode());
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

