/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeDesignator;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeSelector;
import org.jboss.security.xacml.sunxacml.cond.Apply;
import org.jboss.security.xacml.sunxacml.cond.Expression;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.FunctionTypeException;
import org.jboss.security.xacml.sunxacml.cond.VariableManager;
import org.jboss.security.xacml.sunxacml.cond.VariableReference;
import org.w3c.dom.Node;

class ExpressionHandler {
    ExpressionHandler() {
    }

    public static Expression parseExpression(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        String name = root.getNodeName();
        if (name.equals("Apply")) {
            return Apply.getInstance(root, metaData, manager);
        }
        if (name.equals("AttributeValue")) {
            try {
                return AttributeFactory.getInstance().createValue(root);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown DataType", uie);
            }
        }
        if (name.equals("SubjectAttributeDesignator")) {
            return AttributeDesignator.getInstance(root, 0, metaData);
        }
        if (name.equals("ResourceAttributeDesignator")) {
            return AttributeDesignator.getInstance(root, 1, metaData);
        }
        if (name.equals("ActionAttributeDesignator")) {
            return AttributeDesignator.getInstance(root, 2, metaData);
        }
        if (name.equals("EnvironmentAttributeDesignator")) {
            return AttributeDesignator.getInstance(root, 3, metaData);
        }
        if (name.equals("AttributeSelector")) {
            return AttributeSelector.getInstance(root, metaData);
        }
        if (name.equals("Function")) {
            return ExpressionHandler.getFunction(root, metaData, FunctionFactory.getGeneralInstance());
        }
        if (name.equals("VariableReference")) {
            return VariableReference.getInstance(root, metaData, manager);
        }
        return null;
    }

    public static Function getFunction(Node root, PolicyMetaData metaData, FunctionFactory factory) throws ParsingException {
        Node functionNode = root.getAttributes().getNamedItem("FunctionId");
        String functionName = functionNode.getNodeValue();
        try {
            return factory.createFunction(functionName);
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown FunctionId", uie);
        }
        catch (FunctionTypeException fte) {
            try {
                FunctionFactory ff = FunctionFactory.getGeneralInstance();
                return ff.createAbstractFunction(functionName, root, metaData.getXPathIdentifier());
            }
            catch (Exception e) {
                throw new ParsingException("failed to create abstract function " + functionName, e);
            }
        }
    }
}

