/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.ProcessingException;
import org.jboss.security.xacml.sunxacml.cond.ExpressionHandler;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.VariableDefinition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VariableManager {
    private Map idMap = new HashMap();
    private PolicyMetaData metaData;

    public VariableManager(Map variableIds, PolicyMetaData metaData) {
        for (Object key : variableIds.keySet()) {
            Node node = (Node)variableIds.get(key);
            this.idMap.put(key, new VariableState(null, node, null, false, false));
        }
        this.metaData = metaData;
    }

    public VariableDefinition getDefinition(String variableId) {
        VariableState state = (VariableState)this.idMap.get(variableId);
        if (state == null) {
            throw new ProcessingException("variable is unsupported: " + variableId);
        }
        if (state.definition != null) {
            return state.definition;
        }
        Node node = state.rootNode;
        if (node != null) {
            if (state.handled) {
                throw new ProcessingException("processing in progress");
            }
            state.handled = true;
            this.discoverApplyType(node, state);
            try {
                state.definition = VariableDefinition.getInstance(state.rootNode, this.metaData, this);
                return state.definition;
            }
            catch (ParsingException pe) {
                throw new ProcessingException("failed to parse the definition", pe);
            }
        }
        throw new ProcessingException("couldn't retrieve definition: " + variableId);
    }

    private void discoverApplyType(Node root, VariableState state) {
        NodeList nodes = root.getChildNodes();
        Node xprNode = nodes.item(0);
        int i = 1;
        while (xprNode.getNodeType() != 1) {
            xprNode = nodes.item(i++);
        }
        if (xprNode.getNodeName().equals("Apply")) {
            try {
                Function function = ExpressionHandler.getFunction(xprNode, this.metaData, FunctionFactory.getGeneralInstance());
                state.type = function.getReturnType();
                state.returnsBag = function.returnsBag();
            }
            catch (ParsingException pe) {
                // empty catch block
            }
        }
    }

    public URI getVariableType(String variableId) {
        VariableState state = (VariableState)this.idMap.get(variableId);
        if (state == null) {
            throw new ProcessingException("variable not supported: " + variableId);
        }
        if (state.type != null) {
            return state.type;
        }
        VariableDefinition definition = state.definition;
        if (definition == null) {
            definition = this.getDefinition(variableId);
        }
        if (definition != null) {
            return definition.getExpression().getType();
        }
        throw new ProcessingException("we couldn't establish the type: " + variableId);
    }

    public boolean returnsBag(String variableId) {
        VariableState state = (VariableState)this.idMap.get(variableId);
        if (state == null) {
            throw new ProcessingException("variable not supported: " + variableId);
        }
        if (state.type != null) {
            return state.returnsBag;
        }
        VariableDefinition definition = state.definition;
        if (definition == null) {
            definition = this.getDefinition(variableId);
        }
        if (definition != null) {
            return definition.getExpression().returnsBag();
        }
        throw new ProcessingException("couldn't establish bag return for " + variableId);
    }

    class VariableState {
        public VariableDefinition definition;
        public Node rootNode;
        public URI type;
        public boolean returnsBag;
        public boolean handled;

        public VariableState() {
            this.definition = null;
            this.rootNode = null;
            this.type = null;
            this.returnsBag = false;
            this.handled = false;
        }

        public VariableState(VariableDefinition definition, Node rootNode, URI type, boolean returnsBag, boolean handled) {
            this.definition = definition;
            this.rootNode = rootNode;
            this.type = type;
            this.returnsBag = returnsBag;
            this.handled = handled;
        }
    }
}

