/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.PortRange;
import org.w3c.dom.Node;

public class DNSNameAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:2.0:data-type:dnsName";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String hostname;
    private PortRange range;
    private boolean isSubdomain = false;

    public DNSNameAttribute(String hostname) throws ParsingException {
        this(hostname, new PortRange());
    }

    public DNSNameAttribute(String hostname, PortRange range) throws ParsingException {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        if (!this.isValidHostName(hostname)) {
            System.out.println("FIXME: throw error about bad hostname");
        }
        if (hostname.charAt(0) == '*') {
            this.isSubdomain = true;
        }
        this.hostname = hostname;
        this.range = range;
    }

    private boolean isValidHostName(String hostname) {
        String domainlabel = "\\w[[\\w|\\-]*\\w]?";
        String toplabel = "[a-zA-Z][[\\w|\\-]*\\w]?";
        String pattern = "[\\*\\.]?[" + domainlabel + "\\.]*" + toplabel + "\\.?";
        return hostname.matches(pattern);
    }

    public static DNSNameAttribute getInstance(Node root) throws ParsingException {
        return DNSNameAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static DNSNameAttribute getInstance(String value) throws ParsingException {
        int portSep = value.indexOf(58);
        if (portSep == -1) {
            return new DNSNameAttribute(value);
        }
        String hostname = value.substring(0, portSep);
        PortRange range = PortRange.getInstance(value.substring(portSep + 1, value.length()));
        return new DNSNameAttribute(hostname, range);
    }

    public String getHostName() {
        return this.hostname;
    }

    public PortRange getPortRange() {
        return this.range;
    }

    public boolean isSubdomain() {
        return this.isSubdomain;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DNSNameAttribute)) {
            return false;
        }
        DNSNameAttribute other = (DNSNameAttribute)o;
        if (!this.hostname.toUpperCase().equals(other.hostname.toUpperCase())) {
            return false;
        }
        return this.range.equals(other.range);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "DNSNameAttribute: \"" + this.encode() + "\"";
    }

    public String encode() {
        if (this.range.isUnbound()) {
            return this.hostname;
        }
        return this.hostname + ":" + this.range.encode();
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

