/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;

public class FirstApplicablePolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public FirstApplicablePolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    public Result combine(EvaluationCtx context, List parameters, List policyElements) {
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            Result result;
            int effect;
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                return new Result(2, match.getStatus(), context.getResourceId().encode());
            }
            if (match.getResult() != 0 || (effect = (result = policy.evaluate(context)).getDecision()) == 3) continue;
            return result;
        }
        return new Result(3, context.getResourceId().encode());
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

