/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Subject {
    private URI category;
    private Set attributes;
    public static final URI DEFAULT_CATEGORY;
    private static RuntimeException earlyException;

    public Subject(Set attributes) {
        this(null, attributes);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    public Subject(URI category, Set attributes) {
        this.category = category == null ? DEFAULT_CATEGORY : category;
        this.attributes = Collections.unmodifiableSet(new HashSet(attributes));
    }

    public URI getCategory() {
        return this.category;
    }

    public Set getAttributes() {
        return this.attributes;
    }

    static {
        earlyException = null;
        URI defaultURI = null;
        try {
            defaultURI = new URI("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException("invalid URI");
            earlyException.initCause(e);
        }
        DEFAULT_CATEGORY = defaultURI;
    }
}

