/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jboss.security.xacml.sunxacml.ConfigurationStore;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.PDP;
import org.jboss.security.xacml.sunxacml.PDPConfig;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.ctx.RequestCtx;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinder;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.impl.CurrentEnvModule;
import org.jboss.security.xacml.sunxacml.finder.impl.SelectorModule;
import org.jboss.security.xacml.sunxacml.support.finder.StaticPolicyFinderModule;
import org.jboss.security.xacml.sunxacml.support.finder.StaticRefPolicyFinderModule;
import org.jboss.security.xacml.sunxacml.support.finder.URLPolicyFinderModule;

public class SimplePDP {
    private PDP pdp = null;

    public SimplePDP() throws Exception {
        ConfigurationStore store = new ConfigurationStore();
        store.useDefaultFactories();
        this.pdp = new PDP(store.getDefaultPDPConfig());
    }

    public SimplePDP(String[] policies) throws Exception {
        List<String> policyList = Arrays.asList(policies);
        StaticPolicyFinderModule staticModule = new StaticPolicyFinderModule("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides", policyList);
        StaticRefPolicyFinderModule staticRefModule = new StaticRefPolicyFinderModule(policyList);
        URLPolicyFinderModule urlModule = new URLPolicyFinderModule();
        PolicyFinder policyFinder = new PolicyFinder();
        HashSet<PolicyFinderModule> policyModules = new HashSet<PolicyFinderModule>();
        policyModules.add(staticModule);
        policyModules.add(staticRefModule);
        policyModules.add(urlModule);
        policyFinder.setModules(policyModules);
        CurrentEnvModule envAttributeModule = new CurrentEnvModule();
        SelectorModule selectorAttributeModule = new SelectorModule();
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<AttributeFinderModule> attributeModules = new ArrayList<AttributeFinderModule>();
        attributeModules.add(envAttributeModule);
        attributeModules.add(selectorAttributeModule);
        attributeFinder.setModules(attributeModules);
        this.pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
    }

    public ResponseCtx evaluate(String requestFile) throws IOException, ParsingException {
        RequestCtx request = RequestCtx.getInstance(new FileInputStream(requestFile));
        return this.pdp.evaluate(request);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: -config <request>");
            System.out.println("       <request> <policy> [policies]");
            System.exit(1);
        }
        SimplePDP simplePDP = null;
        String requestFile = null;
        if (args[0].equals("-config")) {
            requestFile = args[1];
            simplePDP = new SimplePDP();
        } else {
            requestFile = args[0];
            String[] policyFiles = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                policyFiles[i - 1] = args[i];
            }
            simplePDP = new SimplePDP(policyFiles);
        }
        ResponseCtx response = simplePDP.evaluate(requestFile);
        response.encode(System.out, new Indenter());
    }
}

