/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.ctx.Attribute;
import org.jboss.security.xacml.sunxacml.ctx.InputParser;
import org.jboss.security.xacml.sunxacml.ctx.Subject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestCtx {
    private List subjects = null;
    private List resource = null;
    private List action = null;
    private List environment = null;
    private Node documentRoot = null;
    private String resourceContent;

    public RequestCtx(List subjects, List resource, List action, List environment) {
        this(subjects, resource, action, environment, null, null);
    }

    public RequestCtx(Set subjects, Set resource, Set action, Set environment, Node documentRoot) {
        this(subjects, resource, action, environment, documentRoot, null);
    }

    public RequestCtx(List subjects, List resource, List action, List environment, Node documentRoot) {
        this(subjects, resource, action, environment, documentRoot, null);
    }

    public RequestCtx(Set subjects, Set resource, Set action, Set environment, String resourceContent) {
        this(subjects, resource, action, environment, null, resourceContent);
    }

    public RequestCtx(Set subjects, Set resource, Set action, Set environment, Node documentRoot, String resourceContent) throws IllegalArgumentException {
        this(new ArrayList(subjects), new ArrayList(resource), new ArrayList(action), new ArrayList(environment), documentRoot, resourceContent);
    }

    public RequestCtx(List subjects, List resource, List action, List environment, Node documentRoot, String resourceContent) throws IllegalArgumentException {
        Iterator sIter = subjects.iterator();
        while (sIter.hasNext()) {
            if (sIter.next() instanceof Subject) continue;
            throw new IllegalArgumentException("Subjects input is not well formed");
        }
        this.subjects = Collections.unmodifiableList(subjects);
        Iterator rIter = resource.iterator();
        while (rIter.hasNext()) {
            if (rIter.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Resource input is not well formed");
        }
        this.resource = Collections.unmodifiableList(resource);
        Iterator aIter = action.iterator();
        while (aIter.hasNext()) {
            if (aIter.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Action input is not well formed");
        }
        this.action = Collections.unmodifiableList(action);
        Iterator eIter = environment.iterator();
        while (eIter.hasNext()) {
            if (eIter.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Environment input is not well formed");
        }
        this.environment = Collections.unmodifiableList(environment);
        this.documentRoot = documentRoot;
        this.resourceContent = resourceContent;
    }

    public static RequestCtx getInstance(Node root) throws ParsingException {
        ArrayList<Subject> newSubjects = new ArrayList<Subject>();
        List newResource = null;
        List newAction = null;
        List newEnvironment = null;
        String tagName = SunxacmlUtil.getNodeName(root);
        if (!tagName.equals("Request")) {
            throw new ParsingException("Request cannot be constructed using type: " + SunxacmlUtil.getNodeName(root));
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String tag = SunxacmlUtil.getNodeName(node);
            if (tag.equals("Subject")) {
                Node catNode = node.getAttributes().getNamedItem("SubjectCategory");
                URI category = null;
                if (catNode != null) {
                    try {
                        category = new URI(catNode.getNodeValue());
                    }
                    catch (Exception e) {
                        throw new ParsingException("Invalid Category URI", e);
                    }
                }
                List attributes = RequestCtx.parseAttributes(node);
                newSubjects.add(new Subject(category, attributes));
                continue;
            }
            if (tag.equals("Resource")) {
                newResource = RequestCtx.parseAttributes(node);
                continue;
            }
            if (tag.equals("Action")) {
                newAction = RequestCtx.parseAttributes(node);
                continue;
            }
            if (!tag.equals("Environment")) continue;
            newEnvironment = RequestCtx.parseAttributes(node);
        }
        if (newEnvironment == null) {
            newEnvironment = new ArrayList();
        }
        return new RequestCtx(newSubjects, newResource, newAction, newEnvironment, root);
    }

    private static List parseAttributes(Node root) throws ParsingException {
        ArrayList<Attribute> set = new ArrayList<Attribute>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!SunxacmlUtil.getNodeName(node).equals("Attribute")) continue;
            set.add(Attribute.getInstance(node));
        }
        return set;
    }

    public static RequestCtx getInstance(InputStream input) throws ParsingException {
        return RequestCtx.getInstance(InputParser.parseInput(input, "Request"));
    }

    public Set getSubjects() {
        return Collections.unmodifiableSet(new HashSet(this.subjects));
    }

    public Set getResource() {
        return Collections.unmodifiableSet(new HashSet(this.resource));
    }

    public Set getAction() {
        return Collections.unmodifiableSet(new HashSet(this.action));
    }

    public Set getEnvironmentAttributes() {
        return Collections.unmodifiableSet(new HashSet(this.environment));
    }

    public List getSubjectsAsList() {
        return this.subjects;
    }

    public List getResourceAsList() {
        return this.resource;
    }

    public List getActionAsList() {
        return this.action;
    }

    public List getEnvironmentAttributesAsList() {
        return this.environment;
    }

    public Node getDocumentRoot() {
        return this.documentRoot;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, String nsURI) {
        this.encode(output, new Indenter(0), nsURI);
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String topIndent = indenter.makeString();
        out.println(topIndent + "<Request>");
        indenter.in();
        String indent = indenter.makeString();
        indenter.in();
        for (Subject subject : this.subjects) {
            out.print(indent + "<Subject SubjectCategory=\"" + subject.getCategory().toString() + "\"");
            List subjectAttrs = subject.getAttributesAsList();
            if (subjectAttrs.size() == 0) {
                out.println("/>");
                continue;
            }
            out.println(">");
            this.encodeAttributes(subjectAttrs, out, indenter);
            out.println(indent + "</Subject>");
        }
        if (this.resource.size() != 0 || this.resourceContent != null) {
            out.println(indent + "<Resource>");
            if (this.resourceContent != null) {
                out.println(indenter.makeString() + "<ResourceContent>" + this.resourceContent + "</ResourceContent>");
            }
            this.encodeAttributes(this.resource, out, indenter);
            out.println(indent + "</Resource>");
        } else {
            out.println(indent + "<Resource/>");
        }
        if (this.action.size() != 0) {
            out.println(indent + "<Action>");
            this.encodeAttributes(this.action, out, indenter);
            out.println(indent + "</Action>");
        } else {
            out.println(indent + "<Action/>");
        }
        out.println(indent + "<Environment>");
        if (this.environment.size() != 0) {
            this.encodeAttributes(this.environment, out, indenter);
        }
        out.println(indent + "</Environment>");
        indenter.out();
        indenter.out();
        out.println(topIndent + "</Request>");
    }

    public void encode(OutputStream output, Indenter indenter, String nsURI) {
        PrintStream out = new PrintStream(output);
        String topIndent = indenter.makeString();
        out.println(topIndent + "<Request xmlns='" + nsURI + "'>");
        indenter.in();
        String indent = indenter.makeString();
        indenter.in();
        for (Subject subject : this.subjects) {
            out.print(indent + "<Subject SubjectCategory=\"" + subject.getCategory().toString() + "\"");
            List subjectAttrs = subject.getAttributesAsList();
            if (subjectAttrs.size() == 0) {
                out.println("/>");
                continue;
            }
            out.println(">");
            this.encodeAttributes(subjectAttrs, out, indenter);
            out.println(indent + "</Subject>");
        }
        if (this.resource.size() != 0 || this.resourceContent != null) {
            out.println(indent + "<Resource>");
            if (this.resourceContent != null) {
                out.println(indenter.makeString() + "<ResourceContent>" + this.resourceContent + "</ResourceContent>");
            }
            this.encodeAttributes(this.resource, out, indenter);
            out.println(indent + "</Resource>");
        } else {
            out.println(indent + "<Resource/>");
        }
        if (this.action.size() != 0) {
            out.println(indent + "<Action>");
            this.encodeAttributes(this.action, out, indenter);
            out.println(indent + "</Action>");
        } else {
            out.println(indent + "<Action/>");
        }
        out.println(indent + "<Environment>");
        if (this.environment.size() != 0) {
            this.encodeAttributes(this.environment, out, indenter);
        }
        out.println(indent + "</Environment>");
        indenter.out();
        indenter.out();
        out.println(topIndent + "</Request>");
    }

    private void encodeAttributes(List attributes, PrintStream out, Indenter indenter) {
        for (Attribute attr : attributes) {
            attr.encode(out, indenter);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.subjects == null ? 0 : this.subjects.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestCtx other = (RequestCtx)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        if (this.resourceContent == null ? other.resourceContent != null : !this.resourceContent.equals(other.resourceContent)) {
            return false;
        }
        return !(this.subjects == null ? other.subjects != null : !this.subjects.equals(other.subjects));
    }
}

