/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.bridge;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetFinderModule
extends PolicyFinderModule {
    private PolicySet policySet;
    private List<Policy> policies = new ArrayList<Policy>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    protected PolicyFinder policyFinder = null;

    public PolicySetFinderModule() {
    }

    public PolicySetFinderModule(PolicySet policySet) {
        this.policySet = policySet;
    }

    public PolicySetFinderModule(PolicySet policySet, List<Policy> policies) {
        this.policySet = policySet;
        this.policies.addAll(policies);
    }

    public void init(PolicyFinder finder) {
        this.policyFinder = finder;
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicySet selectedPolicy = null;
        MatchResult match = this.policySet.match(context);
        int result = match.getResult();
        if (result == 2) {
            return new PolicyFinderResult(match.getStatus());
        }
        if (result == 0) {
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = this.policySet;
        }
        return new PolicyFinderResult(selectedPolicy);
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        for (Policy policy : this.policies) {
            if (policy.getId().compareTo(idReference) != 0) continue;
            return new PolicyFinderResult((AbstractPolicy)policy);
        }
        for (PolicySet policySet : this.policySets) {
            if (policySet.getId().compareTo(idReference) != 0) continue;
            return new PolicyFinderResult((AbstractPolicy)policySet);
        }
        return new PolicyFinderResult();
    }

    public boolean isRequestSupported() {
        return true;
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public void set(PolicySet ps, List<Policy> policies, List<PolicySet> policySets) {
        this.policySet = ps;
        this.policies = policies;
        this.policySets = policySets;
    }
}

