/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.security.xacml.bridge.JBossPolicyFinder;
import org.jboss.security.xacml.core.SecurityActions;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.PolicyLocator;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.jaxb.LocatorType;
import org.jboss.security.xacml.jaxb.LocatorsType;
import org.jboss.security.xacml.jaxb.PoliciesType;
import org.jboss.security.xacml.jaxb.PolicySetType;
import org.jboss.security.xacml.jaxb.PolicyType;
import org.jboss.security.xacml.sunxacml.PDP;
import org.jboss.security.xacml.sunxacml.PDPConfig;
import org.jboss.security.xacml.sunxacml.ctx.RequestCtx;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.impl.CurrentEnvModule;
import org.jboss.security.xacml.sunxacml.finder.impl.SelectorModule;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPDP
implements PolicyDecisionPoint {
    private Unmarshaller unmarshaller = null;
    private Set<PolicyLocator> locators = new HashSet<PolicyLocator>();
    private Set<XACMLPolicy> policies = new HashSet<XACMLPolicy>();
    private JBossPolicyFinder policyFinder = new JBossPolicyFinder();

    public JBossPDP() {
    }

    public JBossPDP(InputStream configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(InputSource configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(Node configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(XMLStreamReader configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(URL configFileURL) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFileURL.openStream());
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setLocators(Set<PolicyLocator> locators) {
        this.locators = locators;
    }

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        this.policies = policies;
    }

    @Override
    public ResponseContext evaluate(RequestContext request) {
        HashSet policyModules = new HashSet();
        for (PolicyLocator locator : this.locators) {
            List finderModulesList = (List)locator.get("policy_finder_module");
            if (finderModulesList == null) {
                throw new IllegalStateException("Locator " + locator.getClass().getName() + " has no policy finder modules");
            }
            policyModules.addAll(finderModulesList);
        }
        this.policyFinder.setModules(policyModules);
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<Object> attributeModules = new ArrayList<Object>();
        attributeModules.add(new CurrentEnvModule());
        attributeModules.add(new SelectorModule());
        attributeFinder.setModules(attributeModules);
        PDP pdp = new PDP(new PDPConfig(attributeFinder, (PolicyFinder)this.policyFinder, null));
        RequestCtx req = (RequestCtx)request.get("request_ctx");
        if (req == null) {
            throw new IllegalStateException("Request Context does not contain a request");
        }
        ResponseCtx resp = pdp.evaluate(req);
        ResponseContext response = RequestResponseContextFactory.createResponseContext();
        response.set("response_ctx", resp);
        return response;
    }

    private void bootstrap(org.jboss.security.xacml.jaxb.PDP pdp) throws Exception {
        PoliciesType policiesType = pdp.getPolicies();
        List<PolicySetType> pset = policiesType.getPolicySet();
        this.addPolicySets(pset, true);
        List<XACMLPolicy> policyList = this.addPolicies(policiesType.getPolicy());
        this.policies.addAll(policyList);
        LocatorsType locatorsType = pdp.getLocators();
        List<LocatorType> locs = locatorsType.getLocator();
        for (LocatorType lt : locs) {
            PolicyLocator pl = (PolicyLocator)this.loadClass(lt.getName()).newInstance();
            pl.setPolicies(this.policies);
            this.locators.add(pl);
        }
    }

    private List<XACMLPolicy> addPolicySets(List<PolicySetType> policySets, boolean topLevel) throws Exception {
        ArrayList<XACMLPolicy> list = new ArrayList<XACMLPolicy>();
        for (PolicySetType pst : policySets) {
            String loc = pst.getLocation();
            XACMLPolicy policySet = PolicyFactory.createPolicySet(this.getInputStream(loc), this.policyFinder);
            list.add(policySet);
            List<XACMLPolicy> policyList = this.addPolicies(pst.getPolicy());
            policySet.setEnclosingPolicies(policyList);
            List<PolicySetType> pset = pst.getPolicySet();
            if (pset != null) {
                policySet.getEnclosingPolicies().addAll(this.addPolicySets(pset, false));
            }
            if (!topLevel) continue;
            this.policies.add(policySet);
        }
        return list;
    }

    private List<XACMLPolicy> addPolicies(List<PolicyType> policies) throws Exception {
        ArrayList<XACMLPolicy> policyList = new ArrayList<XACMLPolicy>();
        for (PolicyType pt : policies) {
            policyList.add(PolicyFactory.createPolicy(this.getInputStream(pt.getLocation())));
        }
        return policyList;
    }

    private void createValidatingUnMarshaller() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.jboss.security.xacml.jaxb");
            this.unmarshaller = jc.createUnmarshaller();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            URL schemaURL = tcl.getResource("schema/jbossxacml-2.0.xsd");
            SchemaFactory scFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = scFact.newSchema(schemaURL);
            this.unmarshaller.setSchema(schema);
        }
        catch (Exception jxb) {
            throw new RuntimeException(jxb);
        }
    }

    private InputStream getInputStream(String loc) {
        InputStream is = null;
        try {
            URL url = new URL(loc);
            is = url.openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is == null) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            is = tcl.getResourceAsStream(loc);
        }
        return is;
    }

    private Class<?> loadClass(String fqn) throws Exception {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        return tcl.loadClass(fqn);
    }
}

