/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.factories;

import java.net.InetAddress;
import java.net.URI;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.security.auth.x500.X500Principal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.security.xacml.core.model.policy.AttributeDesignatorType;
import org.jboss.security.xacml.core.model.policy.AttributeValueType;
import org.jboss.security.xacml.core.model.policy.SubjectAttributeDesignatorType;

public class PolicyAttributeFactory {
    public static AttributeValueType createAnyURIAttributeType(URI value) {
        return PolicyAttributeFactory.getBareAttributeValueType("" + value, "http://www.w3.org/2001/XMLSchema#anyURI");
    }

    public static AttributeValueType createBase64BinaryAttributeType(byte[] value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value, "http://www.w3.org/2001/XMLSchema#base64Binary");
    }

    public static AttributeValueType createBooleanAttributeType(boolean value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value, "http://www.w3.org/2001/XMLSchema#boolean");
    }

    public static AttributeValueType createDateAttributeType() {
        return PolicyAttributeFactory.getBareAttributeValueType(PolicyAttributeFactory.getXMLDate(), "http://www.w3.org/2001/XMLSchema#date");
    }

    public static AttributeValueType createDateAttributeType(XMLGregorianCalendar value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value.toXMLFormat(), "http://www.w3.org/2001/XMLSchema#date");
    }

    public static AttributeValueType createDateTimeAttributeType() {
        return PolicyAttributeFactory.getBareAttributeValueType(PolicyAttributeFactory.getXMLDate(), "http://www.w3.org/2001/XMLSchema#dateTime");
    }

    public static AttributeValueType createDateTimeAttributeType(XMLGregorianCalendar value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value.toXMLFormat(), "http://www.w3.org/2001/XMLSchema#dateTime");
    }

    public static AttributeValueType createDNSNameAttributeType(String hostname) {
        return PolicyAttributeFactory.getBareAttributeValueType(hostname, "urn:oasis:names:tc:xacml:2.0:data-type:dnsName");
    }

    public static AttributeValueType createDoubleAttributeType(double value) {
        return PolicyAttributeFactory.getBareAttributeValueType("" + value, "http://www.w3.org/2001/XMLSchema#double");
    }

    public static AttributeValueType createEmailAttributeType(String value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value, "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name");
    }

    public static AttributeValueType createHexBinaryAttributeType(byte[] value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value, "http://www.w3.org/2001/XMLSchema#hexBinary");
    }

    public static AttributeValueType createIntegerAttributeType(int value) {
        return PolicyAttributeFactory.getBareAttributeValueType("" + value, "http://www.w3.org/2001/XMLSchema#integer");
    }

    public static AttributeValueType createIPAddressAttributeType(InetAddress address) {
        return PolicyAttributeFactory.getBareAttributeValueType(address, "urn:oasis:names:tc:xacml:2.0:data-type:ipAddress");
    }

    public static AttributeValueType createStringAttributeType(String value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value, "http://www.w3.org/2001/XMLSchema#string");
    }

    public static AttributeValueType createTimeAttributeType() {
        return PolicyAttributeFactory.getBareAttributeValueType(PolicyAttributeFactory.getXMLDate(), "http://www.w3.org/2001/XMLSchema#time");
    }

    public static AttributeValueType createTimeAttributeType(XMLGregorianCalendar value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value.toXMLFormat(), "http://www.w3.org/2001/XMLSchema#time");
    }

    public static AttributeValueType createX509NameAttributeType(X500Principal value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value, "urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
    }

    public static AttributeValueType createDayTimeDurationAttributeType(Duration value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value.toString(), "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration");
    }

    public static AttributeValueType createYearMonthDurationAttributeType(Duration value) {
        return PolicyAttributeFactory.getBareAttributeValueType(value.toString(), "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration");
    }

    public static AttributeDesignatorType createAttributeDesignatorType(String id, String dataType, String issuer, boolean mustBePresent) {
        AttributeDesignatorType adt = new AttributeDesignatorType();
        adt.setAttributeId(id);
        adt.setDataType(dataType);
        if (issuer != null) {
            adt.setIssuer(issuer);
        }
        adt.setMustBePresent(mustBePresent);
        return adt;
    }

    public static SubjectAttributeDesignatorType createSubjectAttributeDesignatorType(String id, String dataType, String issuer, boolean mustBePresent, String subjectCategory) {
        SubjectAttributeDesignatorType adt = new SubjectAttributeDesignatorType();
        adt.setAttributeId(id);
        adt.setDataType(dataType);
        if (issuer != null) {
            adt.setIssuer(issuer);
        }
        adt.setMustBePresent(mustBePresent);
        if (subjectCategory != null) {
            adt.setSubjectCategory(subjectCategory);
        }
        return adt;
    }

    private static AttributeValueType getBareAttributeValueType(Object value, String dataType) {
        AttributeValueType avt = new AttributeValueType();
        avt.setDataType(dataType);
        avt.getContent().add(value);
        return avt;
    }

    private static String getXMLDate() {
        DatatypeFactory dtf;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        XMLGregorianCalendar value = dtf.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        return value.toXMLFormat();
    }
}

