/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.bridge.PolicySetFinderModule;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.locators.AbstractJBossPolicyLocator;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPolicySetLocator
extends AbstractJBossPolicyLocator {
    private List<PolicySetFinderModule> pfml = new ArrayList<PolicySetFinderModule>();

    public JBossPolicySetLocator() {
    }

    public JBossPolicySetLocator(Set<XACMLPolicy> policies) {
        this.setPolicies(policies);
    }

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        for (XACMLPolicy xp : policies) {
            if (xp.getType() != 0) continue;
            this.pfml.add(this.getPopulatedPolicySetFinderModule(xp));
        }
        this.map.put("policy_finder_module", this.pfml);
    }

    private PolicySetFinderModule getPopulatedPolicySetFinderModule(XACMLPolicy xpolicy) {
        PolicySetFinderModule psfm = new PolicySetFinderModule();
        ArrayList<Policy> sunxacmlPolicies = new ArrayList<Policy>();
        ArrayList<PolicySet> sunxacmlPolicySets = new ArrayList<PolicySet>();
        this.recursivePopulate(xpolicy, sunxacmlPolicySets, sunxacmlPolicies, psfm);
        psfm.set((PolicySet)xpolicy.get("underlying_policy"), sunxacmlPolicies, sunxacmlPolicySets);
        xpolicy.set("policy_finder_module", psfm);
        return psfm;
    }

    private void recursivePopulate(XACMLPolicy policy, List<PolicySet> policySets, List<Policy> policies, PolicySetFinderModule psfm) {
        List<XACMLPolicy> policyList = policy.getEnclosingPolicies();
        for (XACMLPolicy xp : policyList) {
            AbstractPolicy p = (AbstractPolicy)xp.get("underlying_policy");
            if (p instanceof Policy) {
                policies.add((Policy)p);
                continue;
            }
            if (!(p instanceof PolicySet)) continue;
            policySets.add((PolicySet)p);
            this.recursivePopulate(xp, policySets, policies, psfm);
        }
    }
}

