/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators.attrib;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.security.xacml.locators.AttributeLocator;
import org.jboss.security.xacml.locators.attrib.SecurityActions;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.util.JBossXACMLUtil;

public abstract class DatabaseAttributeLocator
extends AttributeLocator {
    private static Logger log = Logger.getLogger(DatabaseAttributeLocator.class.getName());
    protected String dsJNDIName = null;
    protected String dbFileName = null;
    protected String sqlStatement = null;
    protected String preparedStatementValue = null;
    protected String valueDataType = null;
    protected String columnName = null;
    public static final String DS_JNDI_NAME = "DATASOURCE_JNDI_NAME";
    public static final String DB_FILE_NAME = "DATABASE_FILE_NAME";

    public DatabaseAttributeLocator() {
        this.attributeDesignatorSupported = true;
        this.attributeSelectorSupported = true;
        this.designatorTypes.add(0);
        this.designatorTypes.add(1);
        this.designatorTypes.add(2);
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        if (!this.ids.contains(attributeId)) {
            if (attributeType != null) {
                return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeId));
        }
        Object columnValue = this.getColumnValue(attributeType, context);
        HashSet<AttributeValue> bagSet = new HashSet<AttributeValue>();
        bagSet.add(JBossXACMLUtil.getAttributeValue(columnValue));
        return new EvaluationResult((AttributeValue)new BagAttribute(attributeType, bagSet));
    }

    protected void usePassedOption(String optionTag, String optionValue) {
        super.usePassedOption(optionTag, optionValue);
        if (DS_JNDI_NAME.equals(optionTag)) {
            this.dsJNDIName = optionValue;
        }
        if (DB_FILE_NAME.equals(optionTag)) {
            this.dbFileName = optionValue;
        }
        if ("sql".equals(optionTag)) {
            this.sqlStatement = optionValue;
        }
        if ("preparedStatementValue".equals(optionTag)) {
            this.preparedStatementValue = optionValue;
        }
        if ("valueDataType".equals(optionTag)) {
            this.valueDataType = optionValue;
        }
        if ("columnName".equals(optionTag)) {
            this.columnName = optionValue;
        }
    }

    protected Connection getConnection() {
        Connection connection;
        block10: {
            connection = null;
            if (this.dsJNDIName != null) {
                try {
                    InitialContext ctx = new InitialContext();
                    DataSource ds = (DataSource)ctx.lookup(this.dsJNDIName);
                    connection = ds.getConnection();
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINE)) break block10;
                    log.fine("Error looking up connection via Datasource:" + e.getLocalizedMessage());
                }
            }
        }
        if (connection == null && this.dbFileName != null) {
            Properties props = new Properties();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            try {
                props.load(tcl.getResourceAsStream(this.dbFileName));
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading DB file", e);
            }
            try {
                Class.forName(props.getProperty("driverName"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("DB Driver not found:", e);
            }
            try {
                connection = DriverManager.getConnection(props.getProperty("connectionURL"));
            }
            catch (SQLException e) {
                throw new RuntimeException("Cannot get DB Connection:", e);
            }
        }
        return connection;
    }

    protected Object getColumnValue(URI attributeType, EvaluationCtx context) {
        Object columnValue = null;
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(this.sqlStatement);
            Object pluginValue = null;
            try {
                pluginValue = this.getPreparedStatementPluginValue(context, attributeType);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            statement.setObject(1, pluginValue);
            statement.addBatch();
            connection.setAutoCommit(false);
            resultSet = statement.executeQuery();
            connection.setAutoCommit(true);
            if (resultSet.next()) {
                columnValue = resultSet.getObject(this.columnName);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
        return columnValue;
    }

    protected abstract Object getPreparedStatementPluginValue(EvaluationCtx var1, URI var2) throws URISyntaxException;
}

