/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.authorization.resources;

import java.util.HashMap;
import java.util.Map;

import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;

//$Id: EJBResource.java 61962 2007-04-01 04:45:57Z anil.saldhana@jboss.com $

/**
 *  Represents an EJB Resource
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jul 6, 2006 
 *  @version $Revision: 61962 $
 */
public class EJBResource implements Resource
{ 
   private Map<String,Object> map = new HashMap<String,Object>();
   
   /**
    * Create a new EJBResource.
    * 
    * @param map
    */
   public EJBResource(Map map)
   {
     this.map = map;   
   }

   /**
    * @see Resource#getLayer()
    */
   public ResourceType getLayer()
   {
      return ResourceType.EJB;
   }

   /**
    * @see Resource#getMap()
    */
   public Map<String,Object> getMap()
   {
      return this.map;
   } 
  
   /**
    * Set the contextual map
    * @param m Contextual Map
    */
   public void setMap(Map<String,Object> m)
   {
      this.map = m;
   }
   
   public String toString()
   {
      StringBuffer buf = new StringBuffer();
      buf.append("[").append(getClass().getName()).append(":contextMap=").append(map).append("]");
      return buf.toString();
   }
}
