/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;

public class AuthenticationInfo
extends BaseAuthenticationInfo {
    public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
    private CallbackHandler callbackHandler;

    public AuthenticationInfo() {
        this(null);
    }

    public AuthenticationInfo(String name) {
        this.name = name;
    }

    public AppConfigurationEntry[] copyAppConfigurationEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AppConfigurationEntry[] copy = new AppConfigurationEntry[this.moduleEntries.size()];
        for (int i = 0; i < copy.length; ++i) {
            AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
            HashMap options = new HashMap(entry.getOptions());
            options.put("jboss.security.security_domain", this.getName());
            copy[i] = new AppConfigurationEntry(entry.getLoginModuleName(), entry.getControlFlag(), options);
        }
        return copy;
    }

    public void addAppConfigurationEntry(AppConfigurationEntry entry) {
        this.moduleEntries.add(entry);
    }

    public AppConfigurationEntry[] getAppConfigurationEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }

    public void setAppConfigurationEntry(AppConfigurationEntry[] loginModules) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_ENTRY_PERM);
        }
        this.moduleEntries.addAll(Arrays.asList(loginModules));
    }

    public CallbackHandler getAppCallbackHandler() {
        return this.callbackHandler;
    }

    public void setAppCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AppConfigurationEntry[]:\n");
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            AppConfigurationEntry entry = (AppConfigurationEntry)this.moduleEntries.get(i);
            buffer.append("[" + i + "]");
            buffer.append("\nLoginModule Class: " + entry.getLoginModuleName());
            buffer.append("\nControlFlag: " + entry.getControlFlag());
            buffer.append("\nOptions:");
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> e : options.entrySet()) {
                buffer.append("name=" + e.getKey());
                buffer.append(", value=" + e.getValue());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

