/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Users;

public class XMLLoginModule
extends UsernamePasswordLoginModule {
    private Users users;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            this.users = (Users)options.get("userInfo");
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load users/passwords/role files", (Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        if (this.users == null) {
            throw new LoginException("Missing usersInfo user/role mapping");
        }
        return super.login();
    }

    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        Users.User user = this.users.getUser(targetUser);
        Group[] roleSets = new Group[]{};
        if (user != null) {
            roleSets = user.getRoleSets();
        }
        return roleSets;
    }

    protected String getUsersPassword() {
        String username = this.getUsername();
        Users.User user = this.users.getUser(username);
        String password = null;
        if (user != null) {
            password = user.getPassword();
        }
        return password;
    }
}

