/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.SecurityActions;
import org.jboss.security.auth.spi.Util;

public abstract class UsernamePasswordLoginModule
extends AbstractServerLoginModule {
    private Principal identity;
    private char[] credential;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;
    private boolean ignorePasswordCase;
    private boolean hashStorePassword;
    private boolean hashUserPassword = true;
    private boolean legacyCreatePasswordHash;
    private Throwable validateError;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.hashAlgorithm = (String)options.get("hashAlgorithm");
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get("hashEncoding");
            if (this.hashEncoding == null) {
                this.hashEncoding = "BASE64";
            }
            this.hashCharset = (String)options.get("hashCharset");
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Password hashing activated: algorithm = " + this.hashAlgorithm + ", encoding = " + this.hashEncoding + ", charset = " + (this.hashCharset == null ? "{default}" : this.hashCharset) + ", callback = " + options.get("digestCallback") + ", storeCallback = " + options.get("storeDigestCallback")));
            }
        }
        String flag = (String)options.get("ignorePasswordCase");
        this.ignorePasswordCase = Boolean.valueOf(flag);
        flag = (String)options.get("hashStorePassword");
        this.hashStorePassword = Boolean.valueOf(flag);
        flag = (String)options.get("hashUserPassword");
        if (flag != null) {
            this.hashUserPassword = Boolean.valueOf(flag);
        }
        if ((flag = (String)options.get("legacyCreatePasswordHash")) != null) {
            this.legacyCreatePasswordHash = Boolean.valueOf(flag);
        }
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Failed to create principal", (Throwable)e);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = this.unauthenticatedIdentity;
            this.log.trace((Object)("Authenticating as unauthenticatedIdentity=" + this.identity));
        }
        if (this.identity == null) {
            try {
                this.identity = this.createIdentity(username);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
                throw new LoginException("Failed to create principal: " + e.getMessage());
            }
            if (this.hashAlgorithm != null && this.hashUserPassword) {
                password = this.createPasswordHash(username, password, "digestCallback");
            }
            String expectedPassword = this.getUsersPassword();
            if (this.hashAlgorithm != null && this.hashStorePassword) {
                expectedPassword = this.createPasswordHash(username, expectedPassword, "storeDigestCallback");
            }
            if (!this.validatePassword(password, expectedPassword)) {
                Throwable ex = this.getValidateError();
                FailedLoginException fle = new FailedLoginException("Password Incorrect/Password Required");
                if (ex != null) {
                    this.log.debug((Object)("Bad password for username=" + username), ex);
                    fle.initCause(ex);
                } else {
                    this.log.debug((Object)("Bad password for username=" + username));
                }
                throw fle;
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        this.log.trace((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
        return true;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException e) {
            LoginException le = new LoginException("Failed to get username/password");
            le.initCause(e);
            throw le;
        }
        catch (UnsupportedCallbackException e) {
            LoginException le = new LoginException("CallbackHandler does not support: " + e.getCallback());
            le.initCause(e);
            throw le;
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    protected String createPasswordHash(String username, String password, String digestOption) throws LoginException {
        if (this.legacyCreatePasswordHash) {
            try {
                Class[] sig = new Class[]{String.class, String.class};
                Method createPasswordHash = this.getClass().getMethod("createPasswordHash", sig);
                Object[] args = new Object[]{username, password};
                String passwordHash = (String)createPasswordHash.invoke((Object)this, args);
                return passwordHash;
            }
            catch (InvocationTargetException e) {
                LoginException le = new LoginException("Failed to delegate createPasswordHash");
                le.initCause(e.getTargetException());
                throw le;
            }
            catch (Exception e) {
                LoginException le = new LoginException("Failed to delegate createPasswordHash");
                le.initCause(e);
                throw le;
            }
        }
        DigestCallback callback = null;
        String callbackClassName = (String)this.options.get(digestOption);
        if (callbackClassName != null) {
            try {
                ClassLoader loader = SecurityActions.getContextClassLoader();
                Class<?> callbackClass = loader.loadClass(callbackClassName);
                callback = (DigestCallback)callbackClass.newInstance();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Created DigestCallback: " + callback));
                }
            }
            catch (Exception e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Failed to load DigestCallback", (Throwable)e);
                }
                SecurityException ex = new SecurityException("Failed to load DigestCallback");
                ex.initCause(e);
                throw ex;
            }
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.putAll(this.options);
            tmp.put("javax.security.auth.login.name", username);
            tmp.put("javax.security.auth.login.password", password);
            callback.init(tmp);
            Callback[] callbacks = (Callback[])tmp.get("callbacks");
            if (callbacks != null) {
                try {
                    this.callbackHandler.handle(callbacks);
                }
                catch (IOException e) {
                    LoginException le = new LoginException(digestOption + " callback failed");
                    le.initCause(e);
                    throw le;
                }
                catch (UnsupportedCallbackException e) {
                    LoginException le = new LoginException(digestOption + " callback failed");
                    le.initCause(e);
                    throw le;
                }
            }
        }
        String passwordHash = Util.createPasswordHash(this.hashAlgorithm, this.hashEncoding, this.hashCharset, username, password, callback);
        return passwordHash;
    }

    protected Throwable getValidateError() {
        return this.validateError;
    }

    protected void setValidateError(Throwable validateError) {
        this.validateError = validateError;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        boolean valid = false;
        valid = this.ignorePasswordCase ? inputPassword.equalsIgnoreCase(expectedPassword) : inputPassword.equals(expectedPassword);
        return valid;
    }

    protected abstract String getUsersPassword() throws LoginException;
}

