/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import org.jboss.logging.Logger;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.MappingProviderUtil;
import org.jboss.security.mapping.providers.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyContextIdRoleMappingProvider
implements MappingProvider<Group> {
    private static Logger log = Logger.getLogger(PolicyContextIdRoleMappingProvider.class);
    private boolean trace = log.isTraceEnabled();
    private Map<String, Object> options = null;
    private MappingResult<Group> result;
    private Properties policyContextIdToFileNameProps = new Properties();
    private static final String PROPERTIES_ID = "map";
    private static final String EXTERNAL_ID = "externalProperties";

    public void init(Map<String, Object> opt) {
        block5: {
            this.options = opt;
            if (this.trace) {
                log.trace((Object)("Module Options=" + opt));
            }
            if (this.options != null) {
                String filename;
                this.policyContextIdToFileNameProps = (Properties)this.options.get(PROPERTIES_ID);
                if (this.policyContextIdToFileNameProps == null && (filename = (String)this.options.get(EXTERNAL_ID)) != null) {
                    try {
                        this.policyContextIdToFileNameProps = this.loadProperties(filename);
                    }
                    catch (IOException e) {
                        if (!this.trace) break block5;
                        log.trace((Object)"Loading external properties file=", (Throwable)e);
                    }
                }
            }
        }
    }

    public void setMappingResult(MappingResult<Group> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, Group mappedObject) {
        block9: {
            ArrayList tempPrincipalList = new ArrayList();
            Principal principal = null;
            Set principals = (Set)contextMap.get("PrincipalsSet");
            for (Principal p : principals) {
                if (p instanceof Group) continue;
                principal = p;
                break;
            }
            if (principal == null) {
                throw new IllegalStateException("Authenticated Principal not found");
            }
            String contextId = PolicyContext.getContextID();
            if (this.trace) {
                log.trace((Object)("Policy Context ID=" + contextId));
            }
            if (contextId != null && this.policyContextIdToFileNameProps != null && this.policyContextIdToFileNameProps.containsKey(contextId)) {
                String filename = this.policyContextIdToFileNameProps.getProperty(contextId);
                try {
                    Properties props = this.loadProperties(filename);
                    String rolesToAdd = props.getProperty(principal.getName());
                    String[] addRoles = null;
                    if (rolesToAdd != null) {
                        addRoles = MappingProviderUtil.getRolesFromCommaSeparatedString(rolesToAdd);
                    }
                    Enumeration groupMembers = mappedObject.members();
                    while (groupMembers.hasMoreElements()) {
                        tempPrincipalList.add(groupMembers.nextElement());
                    }
                    for (Principal p : tempPrincipalList) {
                        mappedObject.removeMember(p);
                    }
                    MappingProviderUtil.addRoles(mappedObject, addRoles);
                }
                catch (IOException e) {
                    if (!this.trace) break block9;
                    log.trace((Object)"Exception:", (Throwable)e);
                }
            }
        }
        this.result.setMappedObject((Object)mappedObject);
    }

    private Properties loadProperties(String filename) throws IOException {
        Properties props = new Properties();
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        props.load(tcl.getResourceAsStream(filename));
        return props;
    }
}

