/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityAssociationActions {
    SecurityAssociationActions() {
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void pushSecurityContext(final Principal p, final Object cred, final Subject subject, final String securityDomain) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc;
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)securityDomain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                SecurityAssociationActions.setSecurityContext(sc);
                if (SecurityAssociationActions.getServer() == Boolean.FALSE) {
                    SecurityAssociation.pushSubjectContext(subject, p, cred);
                }
                return null;
            }
        });
    }

    static void setPrincipalInfo(Principal principal, Object credential, Subject subject) {
        SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential, subject);
        AccessController.doPrivileged(action);
    }

    static void popPrincipalInfo() {
        PopPrincipalInfoAction action = new PopPrincipalInfoAction();
        AccessController.doPrivileged(action);
    }

    static Boolean getServer() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return SecurityAssociation.isServer();
            }
        });
    }

    static void setServer() {
        AccessController.doPrivileged(SetServerAction.ACTION);
    }

    static void clear() {
        AccessController.doPrivileged(ClearAction.ACTION);
    }

    static Subject getSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static Principal getPrincipal() {
        Principal principal = (Principal)AccessController.doPrivileged(GetPrincipalAction.ACTION);
        return principal;
    }

    static Object getCredential() {
        Object credential = AccessController.doPrivileged(GetCredentialAction.ACTION);
        return credential;
    }

    static SecurityContext createSecurityContext(final String securityDomain) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)securityDomain);
            }
        });
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        public Object run() {
            Object credential = SecurityAssociation.getCredential();
            return credential;
        }
    }

    private static class GetPrincipalAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        public Object run() {
            Principal principal = SecurityAssociation.getPrincipal();
            return principal;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }

    private static class ClearAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new ClearAction();

        private ClearAction() {
        }

        public Object run() {
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityAssociation.clear();
            }
            return null;
        }
    }

    private static class SetServerAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new SetServerAction();

        private SetServerAction() {
        }

        public Object run() {
            SecurityAssociation.setServer();
            return null;
        }
    }

    private static class PopPrincipalInfoAction
    implements PrivilegedAction {
        private PopPrincipalInfoAction() {
        }

        public Object run() {
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityAssociation.popSubjectContext();
            }
            return null;
        }
    }

    private static class SetPrincipalInfoAction
    implements PrivilegedAction {
        Principal principal;
        Object credential;
        Subject subject;

        SetPrincipalInfoAction(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Object run() {
            SecurityContext sc;
            if (!SecurityAssociationActions.getServer().booleanValue()) {
                SecurityAssociation.pushSubjectContext(this.subject, this.principal, this.credential);
            }
            if ((sc = SecurityContextAssociation.getSecurityContext()) == null) {
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)this.principal, (Object)this.credential, (Subject)this.subject, (String)"CLIENT_LOGIN_MODULE");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            SecurityAssociationActions.setSecurityContext(sc);
            this.credential = null;
            this.principal = null;
            this.subject = null;
            return null;
        }
    }
}

