/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityRoleRef;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.resources.EJBResource;

public class EJBPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Principal ejbPrincipal = null;
    private Set<Principal> methodRoles = null;
    private String methodInterface = null;
    private RunAs callerRunAs = null;
    private String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;
    private Set<SecurityRoleRef> securityRoleReferences = null;

    public EJBPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource) {
        if (!(resource instanceof EJBResource)) {
            throw new IllegalArgumentException("resource is not an EJBResource");
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
        if (am == null) {
            throw new IllegalStateException("Authorization Manager is null");
        }
        if (am instanceof PolicyRegistration) {
            this.policyRegistration = (PolicyRegistration)am;
        }
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        this.callerRunAs = ejbResource.getCallerRunAsIdentity();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbName = ejbResource.getEjbName();
        this.ejbPrincipal = ejbResource.getPrincipal();
        this.methodInterface = ejbResource.getEjbMethodInterface();
        this.methodRoles = ejbResource.getMethodRoles();
        this.securityRoleReferences = ejbResource.getSecurityRoleReferences();
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef();
        }
        return this.process();
    }

    private int process() {
        boolean allowed = true;
        if (this.methodRoles == null) {
            if (this.ejbMethod == null) {
                throw new IllegalStateException("ejbMethod is null");
            }
            String method = this.ejbMethod.getName();
            String msg = "No method permissions assigned to method=" + method + ", interface=" + this.methodInterface;
            if (this.trace) {
                log.trace((Object)("Exception:" + msg));
            }
            allowed = false;
        } else if (this.trace) {
            log.trace((Object)("method=" + this.ejbMethod + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles));
        }
        if (!this.methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
            RunAsIdentity callerRunAsIdentity;
            if (this.callerRunAs == null) {
                AuthorizationManager am = (AuthorizationManager)this.policyRegistration;
                if (!am.doesUserHaveRole(this.ejbPrincipal, this.methodRoles)) {
                    if (this.ejbMethod == null) {
                        throw new IllegalStateException("ejbMethod is null");
                    }
                    Set userRoles = am.getUserRoles(this.ejbPrincipal);
                    String method = this.ejbMethod.getName();
                    String msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", principalRoles=" + userRoles;
                    if (this.trace) {
                        log.trace((Object)("Exception:" + msg));
                    }
                    allowed = false;
                }
            } else if (this.callerRunAs instanceof RunAsIdentity && !(callerRunAsIdentity = (RunAsIdentity)this.callerRunAs).doesUserHaveRole(this.methodRoles)) {
                String method = this.ejbMethod.getName();
                String msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
                if (this.trace) {
                    log.trace((Object)("Exception:" + msg));
                }
                allowed = false;
            }
        }
        return allowed ? 1 : -1;
    }

    private int checkRoleRef() {
        AuthorizationManager am = (AuthorizationManager)this.policyRegistration;
        if (this.ejbPrincipal == null && this.callerRunAs == null) {
            if (this.trace) {
                log.trace((Object)"ejbPrincipal = null,callerRunAsIdentity = null => DENY");
            }
            return -1;
        }
        boolean matchFound = false;
        for (SecurityRoleRef meta : this.securityRoleReferences) {
            if (!meta.getName().equals(this.roleName)) continue;
            this.roleName = meta.getLink();
            matchFound = true;
            break;
        }
        if (!matchFound) {
            log.trace((Object)("no match found for security role " + this.roleName + " in the deployment descriptor for ejb " + this.ejbName));
        }
        HashSet<Principal> set = new HashSet<Principal>();
        set.add(new SimplePrincipal(this.roleName));
        boolean allowed = false;
        if (this.callerRunAs == null) {
            allowed = am.doesUserHaveRole(this.ejbPrincipal, set);
        } else if (this.callerRunAs instanceof RunAsIdentity) {
            RunAsIdentity callerRunAsIdentity = (RunAsIdentity)this.callerRunAs;
            allowed = callerRunAsIdentity.doesUserHaveRole(set);
        }
        return allowed ? 1 : -1;
    }
}

