/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import com.sun.xacml.Policy;
import com.sun.xacml.ctx.RequestCtx;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.modules.ejb.EJBXACMLUtil;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;

public class EJBXACMLPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Principal principal = null;

    public EJBXACMLPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource) {
        if (!(resource instanceof EJBResource)) {
            throw new IllegalArgumentException("resource is not an EJBResource");
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
        if (am == null) {
            throw new IllegalStateException("Authorization Manager is null");
        }
        if (am instanceof PolicyRegistration) {
            this.policyRegistration = (PolicyRegistration)am;
        }
        this.ejbName = ejbResource.getEjbName();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.principal = ejbResource.getPrincipal();
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        if (roleRefCheck.booleanValue()) {
            throw new IllegalStateException("SECURIY-50:Role Ref checks not implemented");
        }
        return this.process(am);
    }

    private int process(AuthorizationManager am) {
        int result = -1;
        EJBXACMLUtil util = new EJBXACMLUtil();
        try {
            RequestCtx requestCtx = util.createXACMLRequest(this.ejbName, this.ejbMethod.getName(), this.principal, am.getUserRoles(this.principal));
            String contextID = PolicyContext.getContextID();
            if (contextID == null) {
                throw new IllegalStateException("Context ID is null");
            }
            Policy policy = (Policy)this.policyRegistration.getPolicy(contextID, null);
            if (policy == null) {
                if (this.trace) {
                    log.trace((Object)("Policy obtained is null for contextID:" + contextID));
                }
                throw new IllegalStateException("Missing xacml policy for contextid:" + contextID);
            }
            result = JBossXACMLUtil.checkXACMLAuthorization(requestCtx, policy);
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Exception in processing:", (Throwable)e);
            }
            result = -1;
        }
        return result;
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }
}

