/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentRolesMappingProvider
implements MappingProvider<RoleGroup> {
    private static Logger log = Logger.getLogger(DeploymentRolesMappingProvider.class);
    private boolean trace = log.isTraceEnabled();
    private MappingResult<RoleGroup> result;

    public void init(Map<String, Object> options) {
    }

    public void setMappingResult(MappingResult<RoleGroup> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> map, RoleGroup mappedObject) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Context Map is null or empty");
        }
        Principal principal = (Principal)map.get("Principal");
        Map principalRolesMap = (Map)map.get("deploymentPrincipalRolesMap");
        Set subjectPrincipals = (Set)map.get("PrincipalsSet");
        if (this.trace) {
            log.trace((Object)("Principal=" + principal + ":principalRolesMap=" + principalRolesMap + ":"));
            log.trace((Object)("subjectPrincipals=" + subjectPrincipals));
        }
        if (principalRolesMap == null || principalRolesMap.isEmpty()) {
            this.result.setMappedObject((Object)mappedObject);
            return;
        }
        if (principal != null) {
            mappedObject = this.mapGroup(principal, principalRolesMap, mappedObject);
        }
        if (subjectPrincipals != null) {
            for (Principal p : subjectPrincipals) {
                if (p instanceof Group) continue;
                mappedObject = this.mapGroup(p, principalRolesMap, mappedObject);
            }
        }
        this.result.setMappedObject((Object)mappedObject);
    }

    public boolean supports(Class<?> p) {
        return RoleGroup.class.isAssignableFrom(p);
    }

    private RoleGroup mapGroup(Principal principal, Map<String, Set<String>> principalRolesMap, RoleGroup mappedObject) {
        Set<String> roleset = principalRolesMap.get(principal.getName());
        if (roleset != null) {
            SimpleRoleGroup newRoles = new SimpleRoleGroup("Roles");
            if (roleset != null) {
                for (String r : roleset) {
                    newRoles.addRole((Role)new SimpleRole(r));
                }
            }
            mappedObject.clearRoles();
            mappedObject.getRoles().addAll(newRoles.getRoles());
        }
        return mappedObject;
    }
}

