/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.security.ExternalPasswordCache;
import org.jboss.security.PasswordCache;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);
    private static PasswordCache externalPasswordCache;

    public static char[] loadPassword(String passwordCmd) throws Exception {
        char[] password = null;
        String passwordCmdType = null;
        if (passwordCmd.charAt(0) == '{') {
            StringTokenizer tokenizer = new StringTokenizer(passwordCmd, "{}");
            passwordCmdType = tokenizer.nextToken();
            passwordCmd = tokenizer.nextToken();
        } else {
            password = passwordCmd.toCharArray();
        }
        if (password == null) {
            if (passwordCmdType.startsWith("EXTC") || passwordCmdType.startsWith("CMDC")) {
                long timeOut = 0L;
                if (passwordCmdType.indexOf(58) > -1) {
                    try {
                        String[] token = passwordCmdType.split(":");
                        timeOut = Long.parseLong(token[1]);
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error parsing time out number.", e);
                    }
                }
                if (externalPasswordCache == null) {
                    externalPasswordCache = ExternalPasswordCache.getExternalPasswordCacheInstance();
                }
                if (externalPasswordCache.contains(passwordCmd, timeOut)) {
                    password = externalPasswordCache.getPassword(passwordCmd);
                } else {
                    password = Util.switchCommandExecution(passwordCmdType, passwordCmd);
                    if (password != null) {
                        externalPasswordCache.storePassword(passwordCmd, password);
                    }
                }
            } else if (passwordCmdType.startsWith("EXT") || passwordCmdType.startsWith("CMD")) {
                password = Util.switchCommandExecution(passwordCmdType, passwordCmd);
            } else if (passwordCmdType.equals("CLASS")) {
                password = Util.invokePasswordClass(passwordCmd);
            } else {
                throw new IllegalArgumentException("Invalid password command type: " + passwordCmdType);
            }
        }
        return password;
    }

    private static char[] switchCommandExecution(String passwordCmdType, String passwordCmd) throws Exception {
        if (passwordCmdType.startsWith("EXT")) {
            return Util.execPasswordCmd(passwordCmd);
        }
        if (passwordCmdType.startsWith("CMD")) {
            return Util.execPBBasedPasswordCommand(passwordCmd);
        }
        throw new IllegalArgumentException("Invalid password command type: " + passwordCmdType);
    }

    private static char[] execPasswordCmd(String passwordCmd) throws Exception {
        log.debug((Object)("Executing command: " + passwordCmd));
        String password = Util.execCmd(passwordCmd);
        return password.toCharArray();
    }

    private static char[] invokePasswordClass(String passwordCmd) throws Exception {
        char[] password;
        block6: {
            password = null;
            String classname = passwordCmd;
            String ctorArgs = null;
            int colon = passwordCmd.indexOf(58);
            if (colon > 0) {
                classname = passwordCmd.substring(0, colon);
                ctorArgs = passwordCmd.substring(colon + 1);
            }
            log.debug((Object)("Loading class: " + classname + ", ctorArgs=" + ctorArgs));
            ClassLoader loader = AccessController.doPrivileged(GetTCLAction.ACTION);
            Class<?> c = loader.loadClass(classname);
            Object instance = null;
            if (ctorArgs != null) {
                Object[] args = ctorArgs.split(",");
                Class[] sig = new Class[args.length];
                ArrayList<Class<String>> sigl = new ArrayList<Class<String>>();
                for (int n = 0; n < args.length; ++n) {
                    sigl.add(String.class);
                }
                sigl.toArray(sig);
                Constructor<?> ctor = c.getConstructor(sig);
                instance = ctor.newInstance(args);
            } else {
                instance = c.newInstance();
            }
            try {
                log.debug((Object)"Checking for toCharArray");
                Class[] sig = new Class[]{};
                Method toCharArray = c.getMethod("toCharArray", sig);
                Object[] args = new Object[]{};
                log.debug((Object)"Invoking toCharArray");
                password = (char[])toCharArray.invoke(instance, args);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)"No toCharArray found, invoking toString");
                String tmp = instance.toString();
                if (tmp == null) break block6;
                password = tmp.toCharArray();
            }
        }
        return password;
    }

    private static String execCmd(String cmd) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        String line = sm != null ? RuntimeActions.PRIVILEGED.execCmd(cmd) : RuntimeActions.NON_PRIVILEGED.execCmd(cmd);
        return line;
    }

    private static char[] execPBBasedPasswordCommand(String passwordCmd) throws Exception {
        log.debug((Object)("Executing command: " + passwordCmd));
        SecurityManager sm = System.getSecurityManager();
        String password = sm != null ? RuntimeActions.PB_BASED_PRIVILEGED.execCmd(passwordCmd) : RuntimeActions.PB_BASED_NON_PRIVILEGED.execCmd(passwordCmd);
        return password.toCharArray();
    }

    public static boolean isPasswordCommand(String passwordCmd) {
        return passwordCmd != null && (passwordCmd.startsWith("{EXT}") || passwordCmd.startsWith("{EXTC}") || passwordCmd.startsWith("{CMD}") || passwordCmd.startsWith("{CMDC}") || passwordCmd.startsWith("{CLASS}"));
    }

    public static boolean isPasswordCommand(char[] passwordCmd) {
        return passwordCmd != null && Util.isPasswordCommand(new String(passwordCmd));
    }

    static interface RuntimeActions {
        public static final RuntimeActions PRIVILEGED = new RuntimeActions(){

            public String execCmd(final String cmd) throws Exception {
                try {
                    String line = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return NON_PRIVILEGED.execCmd(cmd);
                        }
                    });
                    return line;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };
        public static final RuntimeActions NON_PRIVILEGED = new RuntimeActions(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String execCmd(String cmd) throws Exception {
                String line;
                InputStream stdin;
                Process p;
                block5: {
                    Runtime rt = Runtime.getRuntime();
                    p = rt.exec(cmd);
                    stdin = null;
                    BufferedReader reader = null;
                    try {
                        stdin = p.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(stdin));
                        line = reader.readLine();
                        Object var8_7 = null;
                        if (reader == null) break block5;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        if (stdin != null) {
                            stdin.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                if (stdin != null) {
                    stdin.close();
                }
                int exitCode = p.waitFor();
                log.debug((Object)("Command exited with: " + exitCode));
                return line;
            }
        };
        public static final RuntimeActions PB_BASED_PRIVILEGED = new RuntimeActions(){

            public String execCmd(final String command) throws Exception {
                try {
                    String password = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return PB_BASED_NON_PRIVILEGED.execCmd(command);
                        }
                    });
                    return password;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };
        public static final RuntimeActions PB_BASED_NON_PRIVILEGED = new RuntimeActions(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public String execCmd(String command) throws Exception {
                String line;
                Process process;
                block3: {
                    String[] parsedCommand = this.parseCommand(command);
                    ProcessBuilder builder = new ProcessBuilder(parsedCommand);
                    process = builder.start();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        line = reader.readLine();
                        Object var8_7 = null;
                        if (reader == null) break block3;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                int exitCode = process.waitFor();
                log.debug((Object)("Command exited with: " + exitCode));
                return line;
            }

            protected String[] parseCommand(String command) {
                String[] parsedCommand = command.split("(?<!\\\\),");
                for (int k = 0; k < parsedCommand.length; ++k) {
                    if (parsedCommand[k].indexOf(92) == -1) continue;
                    parsedCommand[k] = parsedCommand[k].replaceAll("\\\\,", ",");
                }
                return parsedCommand;
            }
        };

        public String execCmd(String var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTCLAction
    implements PrivilegedAction<ClassLoader> {
        static PrivilegedAction<ClassLoader> ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

