/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.security;

import java.security.Permission;

/**
 * Permission to be able to push URL or VirtualFile to AccessControlContextManipulator.
 * @see org.jboss.security.plugins.AccessControlContextManipulator 
 * 
 * @author pskopek
 *
 */
public class PushPermission extends Permission {

   static final long serialVersionUID = 5662546614481285261L;
   
   /**
    *  Creates a new PushPermission object.
    */
   public PushPermission() {
      super("push");
   }
   
   /**
    * Creates a new PushPermission object. This
    * constructor exists for use by the <code>Policy</code> object
    * to instantiate new Permission objects.
    *
    * @param name ignored
    * @param actions ignored.
    */
   public PushPermission(String name, String action) {
      this();
   }

   /**
    * PushPermissions do not imply any other Permission.
    */
   @Override
   public boolean implies(Permission permission) {
      return false;
   }

   /**
    *  Check equality of two PushPermissions. All PushPermisions are equal.
    */
   @Override
   public boolean equals(Object obj) {
      return (obj instanceof PushPermission);
   }

   /* (non-Javadoc)
    * @see java.security.Permission#hashCode()
    */
   @Override
   public int hashCode() {
      return 9;
   }

   /* (non-Javadoc)
    * @see java.security.Permission#getActions()
    */
   @Override
   public String getActions() {
      return "";
   }

}
