/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.callback;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.callback.SecurityActions;
import org.jboss.security.auth.callback.SecurityAssociationCallback;

public class JBossCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private Principal principal;
    private Object credential;

    public JBossCallbackHandler() {
    }

    public JBossCallbackHandler(Principal principal, Object credential) {
        this.principal = principal;
        this.credential = credential;
    }

    public void setSecurityInfo(Principal principal, Object credential) {
        this.principal = principal;
        this.credential = credential;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        int i = 0;
        while (i < callbacks.length) {
            Callback c = callbacks[i];
            if (c instanceof SecurityAssociationCallback) {
                SecurityAssociationCallback sac = (SecurityAssociationCallback)c;
                sac.setPrincipal(this.principal);
                sac.setCredential(this.credential);
            } else if (c instanceof ObjectCallback) {
                ObjectCallback oc = (ObjectCallback)c;
                oc.setCredential(this.credential);
            } else if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                if (this.principal != null) {
                    nc.setName(this.principal.getName());
                }
            } else if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                char[] password = this.getPassword();
                if (password != null) {
                    pc.setPassword(password);
                }
            } else {
                try {
                    CallbackHandler handler = SecurityActions.getContextCallbackHandler();
                    if (handler != null) {
                        Callback[] unknown = new Callback[]{c};
                        handler.handle(unknown);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new UnsupportedCallbackException(c, "Unrecognized Callback");
            }
            ++i;
        }
    }

    private char[] getPassword() {
        char[] password;
        block6: {
            password = null;
            if (this.credential instanceof char[]) {
                password = (char[])this.credential;
            } else if (this.credential instanceof String) {
                String s = (String)this.credential;
                password = s.toCharArray();
            } else {
                try {
                    Class[] types = new Class[]{};
                    Method m = this.credential.getClass().getMethod("toCharArray", types);
                    Object[] args = new Object[]{};
                    password = (char[])m.invoke(this.credential, args);
                }
                catch (Exception e) {
                    if (this.credential == null) break block6;
                    String s = this.credential.toString();
                    password = s.toCharArray();
                }
            }
        }
        return password;
    }
}

