/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLImpl;
import org.jboss.security.acl.ACLProvider;
import org.jboss.security.authorization.Resource;

public class ACLProviderImpl
implements ACLProvider {
    private final Map<Resource, ACL> aclMap = new HashMap<Resource, ACL>();

    public ACL createACL(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("ACLs cannot be created for null resources");
        }
        ACL acl = this.aclMap.get(resource);
        if (acl == null) {
            acl = new ACLImpl(resource);
            this.aclMap.put(resource, acl);
        }
        return acl;
    }

    public boolean removeACL(ACL acl) {
        return this.removeACL(acl.getResource());
    }

    public boolean removeACL(Resource resource) {
        return this.aclMap.remove(resource) != null;
    }

    public ACL retrieveACL(Resource resource) {
        return this.aclMap.get(resource);
    }

    public boolean updateACL(ACL acl) {
        if (!this.aclMap.containsKey(acl.getResource())) {
            return false;
        }
        return this.aclMap.put(acl.getResource(), acl) != null;
    }
}

