/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.authorization.Resource;
import org.jboss.security.identity.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLImpl
implements ACL {
    private final Resource resource;
    private final Map<Identity, ACLEntry> entries;

    public ACLImpl(Resource resource) {
        this(resource, new ArrayList<ACLEntry>());
    }

    public ACLImpl(Resource resource, Collection<ACLEntry> entries) {
        this.resource = resource;
        this.entries = new HashMap<Identity, ACLEntry>();
        for (ACLEntry entry : entries) {
            this.entries.put(entry.getIdentity(), entry);
        }
    }

    public boolean addEntry(ACLEntry entry) {
        if (entry == null || this.entries.get(entry.getIdentity()) != null) {
            return false;
        }
        this.entries.put(entry.getIdentity(), entry);
        return true;
    }

    public boolean removeEntry(ACLEntry entry) {
        return this.entries.remove(entry.getIdentity()) != null;
    }

    public Collection<ACLEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isGranted(ACLPermission permission, Identity identity) {
        ACLEntry entry = this.entries.get(identity);
        if (entry != null) {
            return entry.checkPermission(permission);
        }
        return false;
    }
}

