/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.MappingProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalToRoleMappingProvider
implements MappingProvider<Group> {
    private static final Logger log = Logger.getLogger(PrincipalToRoleMappingProvider.class);
    private static final String PRINCIPAL_ROLES_MAP = "principalRolesMap";
    private Map<String, Object> options = null;
    private MappingResult<Group> result;
    private Properties principalRoleMapProperties = null;

    public void init(Map<String, Object> opt) {
        this.options = opt;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Module Options=" + this.options));
        }
        if (this.options != null && this.options.containsKey(PRINCIPAL_ROLES_MAP)) {
            this.principalRoleMapProperties = (Properties)this.options.get(PRINCIPAL_ROLES_MAP);
        }
    }

    public void setMappingResult(MappingResult<Group> res) {
        this.result = res;
    }

    public void performMapping(Map<String, Object> contextMap, Group mappedObject) {
        Set principals = (Set)contextMap.get("PrincipalsSet");
        for (Principal p : principals) {
            String[] tokens;
            String pname = p.getName().trim();
            boolean containsP = this.principalRoleMapProperties.containsKey(pname);
            log.trace((Object)("Principal:" + pname + " is contained in options map:" + containsP));
            if (!containsP) continue;
            String commaSeparatedRoles = this.principalRoleMapProperties.getProperty(pname);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Principal:" + p.getName() + ":roles add=" + commaSeparatedRoles));
            }
            int len = (tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles)) != null ? tokens.length : 0;
            for (int i = 0; i < len; ++i) {
                mappedObject.addMember(MappingProviderUtil.instantiatePrincipal(p.getClass(), tokens[i]));
            }
        }
        this.result.setMappedObject((Object)mappedObject);
    }
}

