/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLEntryImpl;
import org.jboss.security.acl.ACLImpl;
import org.jboss.security.acl.ACLPersistenceStrategy;
import org.jboss.security.acl.Util;
import org.jboss.security.authorization.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAPersistenceStrategy
implements ACLPersistenceStrategy {
    private final Map<Resource, ACL> aclMap = new HashMap<Resource, ACL>();
    private final EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"ACL");

    public ACL createACL(Resource resource) {
        return this.createACL(resource, new ArrayList<ACLEntry>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACL createACL(Resource resource, Collection<ACLEntry> entries) {
        if (resource == null) {
            throw new IllegalArgumentException("ACLs cannot be created for null resources");
        }
        ACL acl = this.aclMap.get(resource);
        if (acl == null) {
            EntityManager entityManager = this.factory.createEntityManager();
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                acl = new ACLImpl(resource, entries);
                entityManager.persist((Object)acl);
                this.aclMap.put(resource, acl);
                transaction.commit();
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                transaction.rollback();
            }
            finally {
                entityManager.close();
            }
        }
        return acl;
    }

    public boolean removeACL(ACL acl) {
        return this.removeACL(acl.getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeACL(Resource resource) {
        boolean result = false;
        EntityManager entityManager = this.factory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        try {
            ACLImpl acl = this.findACLByResource(resource, entityManager);
            if (acl != null) {
                entityManager.remove((Object)acl);
                result = this.aclMap.remove(resource) != null;
            }
            transaction.commit();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            transaction.rollback();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACL getACL(Resource resource) {
        ACL acl = this.aclMap.get(resource);
        if (acl == null) {
            EntityManager entityManager = this.factory.createEntityManager();
            try {
                acl = this.findACLByResource(resource, entityManager);
                if (acl != null) {
                    this.aclMap.put(resource, acl);
                }
            }
            finally {
                entityManager.close();
            }
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateACL(ACL acl) {
        if (((ACLImpl)acl).getACLId() == 0L) {
            return false;
        }
        EntityManager entityManager = this.factory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        try {
            for (ACLEntry entry : acl.getEntries()) {
                ACLEntryImpl entryImpl = (ACLEntryImpl)entry;
                if (entryImpl.getACLEntryId() != 0L) continue;
                entityManager.persist((Object)entryImpl);
            }
            entityManager.merge((Object)acl);
            this.aclMap.put(acl.getResource(), acl);
            transaction.commit();
            boolean i$ = true;
            return i$;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            transaction.rollback();
        }
        finally {
            entityManager.close();
        }
        return false;
    }

    private ACLImpl findACLByResource(Resource resource, EntityManager entityManager) {
        ACLImpl acl = null;
        try {
            acl = (ACLImpl)entityManager.createQuery("SELECT a FROM ACLImpl a WHERE a.resourceAsString LIKE '" + Util.getResourceAsString(resource) + "'").getSingleResult();
            acl.setResource(resource);
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return acl;
    }
}

