/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import com.sun.xacml.Policy;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.AuthorizationContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.EntitlementHolder;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.callbacks.SecurityContextCallback;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.JBossSecurityContext;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.security.plugins.acl.JBossACLContext;
import org.jboss.security.plugins.authorization.JBossAuthorizationContext;
import org.jboss.util.NotImplementedException;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAuthorizationManager
implements AuthorizationManager,
PolicyRegistration {
    private String securityDomain;
    private Map<String, Policy> contextIdToPolicy = new HashMap<String, Policy>();
    private static Logger log = Logger.getLogger(JBossAuthorizationManager.class);
    protected boolean trace = log.isTraceEnabled();
    private AuthorizationContext authorizationContext = null;
    private Lock lock = new ReentrantLock();

    public JBossAuthorizationManager(String securityDomainName) {
        this.securityDomain = securityDomainName;
    }

    public int authorize(Resource resource) throws AuthorizationException {
        this.validateResource(resource);
        String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        Subject subject = null;
        try {
            subject = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
        }
        catch (PolicyContextException e) {
            log.error((Object)"Error obtaining AuthenticatedSubject:", (Throwable)e);
        }
        return this.internalAuthorization(resource, subject, null);
    }

    public int authorize(Resource resource, Subject subject, RoleGroup role) throws AuthorizationException {
        this.validateResource(resource);
        return this.internalAuthorization(resource, subject, role);
    }

    public int authorize(Resource resource, Subject subject, Group roleGroup) throws AuthorizationException {
        this.validateResource(resource);
        return this.internalAuthorization(resource, subject, this.getRoleGroup(roleGroup));
    }

    public <T> EntitlementHolder<T> getEntitlements(Class<T> clazz, Resource resource, Identity identity) throws AuthorizationException {
        JBossACLContext aclContext = new JBossACLContext(this.securityDomain);
        return aclContext.getEntitlements(clazz, resource, identity);
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> rolePrincipals) {
        boolean hasRole = false;
        RoleGroup roles = this.getCurrentRoles(principal);
        if (this.trace) {
            log.trace((Object)("doesUserHaveRole(Set), roles: " + roles));
        }
        if (roles != null) {
            Iterator<Principal> iter = rolePrincipals.iterator();
            while (!hasRole && iter.hasNext()) {
                Principal role = iter.next();
                hasRole = this.doesRoleGroupHaveRole(role, roles);
                if (!this.trace) continue;
                log.trace((Object)("hasRole(" + role + ")=" + hasRole));
            }
            if (this.trace) {
                log.trace((Object)("hasRole=" + hasRole));
            }
        }
        return hasRole;
    }

    public boolean doesUserHaveRole(Principal principal, Principal role) {
        boolean hasRole = false;
        RoleGroup roles = this.getCurrentRoles(principal);
        hasRole = this.doesRoleGroupHaveRole(role, roles);
        return hasRole;
    }

    public Set<Principal> getUserRoles(Principal principal) {
        RoleGroup userRoles = this.getCurrentRoles(principal);
        return this.getRolesAsSet(userRoles);
    }

    protected boolean doesRoleGroupHaveRole(Principal role, RoleGroup userRoles) {
        if (role instanceof NobodyPrincipal) {
            return false;
        }
        boolean isMember = userRoles.containsRole((Role)new SimpleRole(role.getName()));
        if (!isMember) {
            isMember = role instanceof AnybodyPrincipal;
        }
        return isMember;
    }

    public void registerPolicy(String contextID, URL location) {
        try {
            if (this.trace) {
                log.trace((Object)("Registering policy for contextId:" + contextID + " and location:" + location.getPath()));
            }
            this.registerPolicy(contextID, location.openStream());
        }
        catch (Exception e) {
            log.debug((Object)"Error in registering xacml policy:", (Throwable)e);
        }
    }

    public void registerPolicy(String contextID, InputStream stream) {
        try {
            Element elm = DOMUtils.parse((InputStream)stream);
            Policy policy = Policy.getInstance((Node)elm);
            this.contextIdToPolicy.put(contextID, policy);
        }
        catch (Exception e) {
            log.debug((Object)"Error in registering xacml policy:", (Throwable)e);
        }
    }

    public void deRegisterPolicy(String contextID) {
        this.contextIdToPolicy.remove(contextID);
        if (this.trace) {
            log.trace((Object)("DeRegistered policy for contextId:" + contextID));
        }
    }

    public Object getPolicy(String contextID, Map<String, Object> contextMap) {
        return this.contextIdToPolicy.get(contextID);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AuthorizationManager:class=").append(this.getClass().getName());
        buf.append(":").append(this.securityDomain).append(":");
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorizationContext(AuthorizationContext ac) {
        if (ac == null) {
            throw new IllegalArgumentException("AuthorizationContext is null");
        }
        this.lock.lock();
        try {
            String sc = ac.getSecurityDomain();
            if (!this.securityDomain.equals(sc)) {
                throw new IllegalArgumentException("The Security Domain " + sc + " does not match with " + this.securityDomain);
            }
            this.authorizationContext = ac;
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Group getTargetRoles(Principal targetPrincipal, Map<String, Object> contextMap) {
        throw new NotImplementedException();
    }

    private HashSet<Principal> getRolesAsSet(RoleGroup roles) {
        HashSet<SimplePrincipal> userRoles = null;
        if (roles != null) {
            userRoles = new HashSet<SimplePrincipal>();
            List rolesList = roles.getRoles();
            for (Role r : rolesList) {
                userRoles.add(new SimplePrincipal(r.getRoleName()));
            }
        }
        return userRoles;
    }

    public RoleGroup getSubjectRoles(Subject authenticatedSubject, CallbackHandler cbh) {
        if (authenticatedSubject == null) {
            return null;
        }
        SecurityContextCallback scb = new SecurityContextCallback();
        try {
            cbh.handle(new Callback[]{scb});
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getSubjectRoles:", (Throwable)e);
            throw new RuntimeException(e);
        }
        SecurityContext sc = scb.getSecurityContext();
        RoleGroup roles = this.getCurrentRoles(null, authenticatedSubject, sc);
        if (roles == null) {
            roles = new SimpleRoleGroup("Roles");
        }
        return roles;
    }

    private RoleGroup getCurrentRoles(Principal principal) {
        Subject subject = null;
        try {
            subject = SubjectActions.getActiveSubject();
        }
        catch (PrivilegedActionException e) {
            throw new IllegalStateException(e);
        }
        SecurityContext sc = SubjectActions.getSecurityContext();
        if (sc == null) {
            sc = new JBossSecurityContext(this.securityDomain);
            SubjectActions.setSecurityContext(sc);
        }
        return this.getCurrentRoles(principal, subject, sc);
    }

    private RoleGroup getCurrentRoles(Principal principal, Subject subject, SecurityContext sc) {
        if (subject == null) {
            throw new IllegalArgumentException("Subject passed is null");
        }
        if (sc == null) {
            throw new IllegalArgumentException("Sec Ctx sc passed is null");
        }
        Group subjectRoles = this.getGroupFromSubject(subject);
        boolean emptyContextRoles = false;
        RoleGroup userRoles = sc.getUtil().getRoles();
        if (userRoles == null || "true".equalsIgnoreCase(SubjectActions.getRefreshSecurityContextRoles())) {
            emptyContextRoles = true;
        }
        if (subjectRoles != (userRoles = this.copyGroups(userRoles, subjectRoles)) || emptyContextRoles) {
            MappingManager mm = sc.getMappingManager();
            MappingContext mc = mm.getMappingContext(RoleGroup.class);
            RoleGroup mappedUserRoles = userRoles;
            if (mc != null && mc.hasModules()) {
                HashMap<String, Object> contextMap = new HashMap<String, Object>();
                contextMap.put("Roles", userRoles);
                if (principal != null) {
                    contextMap.put("Principal", principal);
                }
                contextMap.put("deploymentPrincipalRolesMap", SecurityRolesAssociation.getSecurityRoles());
                contextMap.put("PrincipalsSet", subject.getPrincipals());
                if (this.trace) {
                    log.trace((Object)("Roles before mapping:" + userRoles));
                }
                mc.performMapping(contextMap, (Object)userRoles);
                mappedUserRoles = (RoleGroup)mc.getMappingResult().getMappedObject();
                if (this.trace) {
                    log.trace((Object)("Roles after mapping:" + userRoles));
                }
            }
            sc.getData().put("Roles", mappedUserRoles);
        }
        return userRoles;
    }

    private RoleGroup copyGroups(RoleGroup source, Group toCopy) {
        if (toCopy == null) {
            return source;
        }
        if (source == null && toCopy != null) {
            source = new SimpleRoleGroup("Roles");
        }
        Enumeration en = toCopy.members();
        while (en.hasMoreElements()) {
            source.addRole((Role)new SimpleRole(((Principal)en.nextElement()).getName()));
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalAuthorization(Resource resource, Subject subject, RoleGroup role) throws AuthorizationException {
        this.lock.lock();
        try {
            if (this.authorizationContext == null) {
                this.authorizationContext = new JBossAuthorizationContext(this.securityDomain);
            }
            int n = this.authorizationContext.authorize(resource, subject, role);
            Object var6_5 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private Group getGroupFromSubject(Subject theSubject) {
        if (theSubject == null) {
            throw new IllegalArgumentException("Subject is null");
        }
        Set<Group> subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator<Group> iter = subjectGroups.iterator();
        Group roles = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roles = grp;
        }
        return roles;
    }

    private RoleGroup getRoleGroup(Group roleGroup) {
        if (roleGroup == null) {
            throw new IllegalArgumentException("roleGroup is null");
        }
        SimpleRoleGroup srg = new SimpleRoleGroup(roleGroup.getName());
        Enumeration principals = roleGroup.members();
        while (principals.hasMoreElements()) {
            srg.getRoles().add(new SimpleRole(((Principal)principals.nextElement()).getName()));
        }
        return srg;
    }

    private void validateResource(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (resource.getMap() == null) {
            throw new IllegalArgumentException("resource has null context map");
        }
    }
}

