/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.Key;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.resource.security.SecureIdentityLoginModule;
import org.jboss.resource.security.SubjectActions;
import org.jboss.security.Base64Utils;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.Util;

public class PBEIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger(SecureIdentityLoginModule.class);
    private String username;
    private String password;
    private char[] pbepass = "jaas is the way".toCharArray();
    private String pbealgo = "PBEwithMD5andDES";
    private byte[] salt = new byte[]{1, 7, 2, 9, 3, 11, 4, 13};
    private int iterationCount = 37;
    private PBEParameterSpec cipherSpec;

    public PBEIdentityLoginModule() {
    }

    PBEIdentityLoginModule(String algo, char[] pass, byte[] pbesalt, int iter) {
        if (pass != null) {
            this.pbepass = pass;
        }
        if (algo != null) {
            this.pbealgo = algo;
        }
        if (pbesalt != null) {
            this.salt = pbesalt;
        }
        if (iter > 0) {
            this.iterationCount = iter;
        }
    }

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.username = (String)options.get("username");
        if (this.username == null) {
            this.username = (String)options.get("userName");
            if (this.username == null) {
                throw new IllegalArgumentException("The user name is a required option");
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            throw new IllegalArgumentException("The password is a required option");
        }
        String tmp = (String)options.get("pbepass");
        if (tmp != null) {
            try {
                this.pbepass = Util.loadPassword(tmp);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if ((tmp = (String)options.get("pbealgo")) != null) {
            this.pbealgo = tmp;
        }
        if ((tmp = (String)options.get("salt")) != null) {
            this.salt = tmp.substring(0, 8).getBytes();
        }
        if ((tmp = (String)options.get("iterationCount")) != null) {
            this.iterationCount = Integer.parseInt(tmp);
        }
    }

    public boolean login() throws LoginException {
        log.trace((Object)"login called");
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        SimplePrincipal principal = new SimplePrincipal(this.username);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.username);
        try {
            char[] decodedPassword = this.decode(this.password);
            PasswordCredential cred = new PasswordCredential(this.username, decodedPassword);
            cred.setManagedConnectionFactory(this.getMcf());
            SubjectActions.addCredentials(this.subject, cred);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to decode password", (Throwable)e);
            throw new LoginException("Failed to decode password: " + e.getMessage());
        }
        return true;
    }

    public boolean abort() {
        this.username = null;
        this.password = null;
        return true;
    }

    protected Principal getIdentity() {
        log.trace((Object)("getIdentity called, username=" + this.username));
        SimplePrincipal principal = new SimplePrincipal(this.username);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] empty = new Group[]{};
        return empty;
    }

    private String encode(String secret) throws Exception {
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.pbepass);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbealgo);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        Cipher cipher = Cipher.getInstance(this.pbealgo);
        cipher.init(1, (Key)cipherKey, this.cipherSpec);
        byte[] encoding = cipher.doFinal(secret.getBytes());
        return Base64Utils.tob64(encoding);
    }

    private char[] decode(String secret) throws Exception {
        this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.pbepass);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbealgo);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        byte[] encoding = Base64Utils.fromb64(secret);
        Cipher cipher = Cipher.getInstance(this.pbealgo);
        cipher.init(2, (Key)cipherKey, this.cipherSpec);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode).toCharArray();
    }

    public static void main(String[] args) throws Exception {
        String algo = null;
        char[] pass = "jaas is the way".toCharArray();
        byte[] salt = null;
        int iter = -1;
        if (args.length >= 2) {
            pass = args[1].toCharArray();
        }
        if (args.length >= 3) {
            salt = args[2].getBytes();
        }
        if (args.length >= 4) {
            iter = Integer.decode(args[3]);
        }
        if (args.length >= 5) {
            algo = args[4];
        }
        PBEIdentityLoginModule pbe = new PBEIdentityLoginModule(algo, pass, salt, iter);
        String encode = pbe.encode(args[0]);
        System.out.println("Encoded password: " + encode);
    }
}

