/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLImpl;
import org.jboss.security.acl.config.ACLConfiguration;
import org.jboss.security.acl.config.ACLConfigurationFactory;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.interfaces.XACMLPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPolicyRegistration
implements PolicyRegistration,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(JBossPolicyRegistration.class);
    protected boolean trace = log.isTraceEnabled();
    private final Map<String, Set<XACMLPolicy>> contextIdToXACMLPolicy = new HashMap<String, Set<XACMLPolicy>>();
    private final Map<String, JBossPDP> contextIDToJBossPDP = new HashMap<String, JBossPDP>();
    private final Map<String, Set<ACL>> contextIDToACLs = new HashMap<String, Set<ACL>>();
    private final Map<String, ACL> configuredACLs = new HashMap<String, ACL>();

    public void deRegisterPolicy(String contextID, String type) {
        if ("XACML".equalsIgnoreCase(type)) {
            this.contextIdToXACMLPolicy.remove(contextID);
            if (this.trace) {
                log.trace((Object)("DeRegistered policy for contextId:" + contextID + ":type=" + type));
            }
        } else if ("ACL".equalsIgnoreCase(type)) {
            Set<ACL> acls = this.contextIDToACLs.remove(contextID);
            for (ACL acl : acls) {
                ACLImpl impl = (ACLImpl)acl;
                this.configuredACLs.remove(impl.getResourceAsString());
            }
            if (this.trace) {
                log.trace((Object)("Deregistered ACLs for contextId:" + contextID));
            }
        }
    }

    public <T> T getPolicy(String contextID, String type, Map<String, Object> contextMap) {
        if ("XACML".equalsIgnoreCase(type)) {
            String pdp;
            if (contextMap != null && (pdp = (String)contextMap.get("PDP")) != null) {
                return (T)this.contextIDToJBossPDP.get(contextID);
            }
            return (T)this.contextIdToXACMLPolicy.get(contextID);
        }
        if ("ACL".equalsIgnoreCase(type)) {
            if (contextMap != null) {
                String query = (String)contextMap.get("resource");
                if ("ALL".equalsIgnoreCase(query)) {
                    return (T)this.configuredACLs.values();
                }
                if (query != null) {
                    return (T)this.configuredACLs.get(query);
                }
            }
            return (T)this.contextIDToACLs.get(contextID);
        }
        throw new RuntimeException("Unsupported type:" + type);
    }

    public void registerPolicy(String contextID, String type, URL location) {
        try {
            if (this.trace) {
                log.trace((Object)("Registering policy for contextId:" + contextID + " type: " + type + "and location:" + location.getPath()));
            }
            this.registerPolicy(contextID, type, location.openStream());
        }
        catch (Exception e) {
            log.debug((Object)"Error in registering policy:", (Throwable)e);
        }
    }

    public void registerPolicy(String contextID, String type, InputStream stream) {
        if ("XACML".equalsIgnoreCase(type)) {
            try {
                XACMLPolicy policy = PolicyFactory.createPolicy((InputStream)stream);
                Set<XACMLPolicy> policySet = this.contextIdToXACMLPolicy.get(contextID);
                if (policySet == null) {
                    policySet = new HashSet<XACMLPolicy>();
                }
                policySet.add(policy);
                this.contextIdToXACMLPolicy.put(contextID, policySet);
            }
            catch (Exception e) {
                log.debug((Object)"Error in registering xacml policy:", (Throwable)e);
            }
        } else if ("ACL".equalsIgnoreCase(type)) {
            ACLConfiguration configuration = ACLConfigurationFactory.getConfiguration(stream);
            Set<ACL> configuredACLs = configuration.getConfiguredACLs();
            this.contextIDToACLs.put(contextID, configuredACLs);
            for (ACL acl : configuredACLs) {
                ACLImpl impl = (ACLImpl)acl;
                if (this.trace) {
                    log.trace((Object)("Registering ACL for resource " + impl.getResourceAsString()));
                }
                this.configuredACLs.put(impl.getResourceAsString(), acl);
            }
        }
    }

    public void registerPolicyConfigFile(String contextId, String type, InputStream stream) {
        if ("XACML".equalsIgnoreCase(type)) {
            try {
                JBossPDP pdp = new JBossPDP(stream);
                this.contextIDToJBossPDP.put(contextId, pdp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

