/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.config.ModuleOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthModuleEntry {
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    private Map<String, Object> options = new HashMap<String, Object>();
    private String name = null;
    private LoginModuleStackHolder loginModuleStackHolder = null;
    private String loginModuleStackHolderName = null;

    public AuthModuleEntry(String authModuleName, Map<String, Object> options, String loginModuleStackHolderName) {
        this.name = authModuleName;
        if (options != null) {
            this.options = options;
        }
        this.loginModuleStackHolderName = loginModuleStackHolderName;
    }

    public String getAuthModuleName() {
        return this.name;
    }

    public void addOption(ModuleOption option) {
        if (option == null) {
            throw new IllegalArgumentException("Option is null");
        }
        if (this.options == null) {
            throw new IllegalStateException("Options is null");
        }
        this.options.put(option.getName(), option.getValue());
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public LoginModuleStackHolder getLoginModuleStackHolder() {
        return this.loginModuleStackHolder;
    }

    public void setLoginModuleStackHolder(LoginModuleStackHolder loginModuleStackHolder) {
        if (loginModuleStackHolder == null) {
            throw new IllegalArgumentException("loginModuleStackHolder is null");
        }
        this.loginModuleStackHolder = loginModuleStackHolder;
        this.loginModuleStackHolderName = this.loginModuleStackHolder.getName();
    }

    public String getLoginModuleStackHolderName() {
        return this.loginModuleStackHolderName;
    }

    public void setLoginModuleStackHolderName(String loginModuleStackHolderName) {
        if (loginModuleStackHolderName == null) {
            throw new IllegalArgumentException("loginModuleStackHolderName is null");
        }
        this.loginModuleStackHolderName = loginModuleStackHolderName;
    }

    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public void setControlFlag(AppConfigurationEntry.LoginModuleControlFlag flag) {
        this.controlFlag = flag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append("{");
        builder.append(this.name).append(":").append(this.options);
        builder.append("}");
        return builder.toString();
    }
}

