/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.security.Principal;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.PolicyConfig;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identity.RoleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationPolicy {
    private final String name;
    private BaseAuthenticationInfo authenticationInfo;
    private ACLInfo aclInfo;
    private AuthorizationInfo authorizationInfo;
    private AuditInfo auditInfo;
    private MappingInfo roleMappingInfo;
    private MappingInfo principalMappingInfo;
    private IdentityTrustInfo identityTrustInfo;
    private String baseApplicationPolicyName;
    private PolicyConfig policyConfig;

    public ApplicationPolicy(String theName) {
        if (theName == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = theName;
    }

    public ApplicationPolicy(String theName, BaseAuthenticationInfo info) {
        this(theName);
        this.authenticationInfo = info;
    }

    public ApplicationPolicy(String theName, AuthorizationInfo info) {
        this(theName);
        this.authorizationInfo = info;
    }

    public ApplicationPolicy(String theName, BaseAuthenticationInfo info, AuthorizationInfo info2) {
        this(theName);
        this.authenticationInfo = info;
        this.authorizationInfo = info2;
    }

    public ACLInfo getAclInfo() {
        ACLInfo info = null;
        ApplicationPolicy basePolicy = this.getBaseApplicationPolicy();
        if (basePolicy != null) {
            info = basePolicy.getAclInfo();
        }
        if (info != null && this.aclInfo == null) {
            return info;
        }
        if (info != null) {
            return (ACLInfo)this.aclInfo.merge(info);
        }
        return this.aclInfo;
    }

    public void setAclInfo(ACLInfo aclInfo) {
        this.aclInfo = aclInfo;
    }

    public BaseAuthenticationInfo getAuthenticationInfo() {
        BaseAuthenticationInfo bai = null;
        ApplicationPolicy ap = this.getBaseApplicationPolicy();
        if (ap != null) {
            bai = ap.getAuthenticationInfo();
        }
        if (bai != null && this.authenticationInfo == null) {
            return bai;
        }
        if (bai != null) {
            return (BaseAuthenticationInfo)this.authenticationInfo.merge(bai);
        }
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(BaseAuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }

    public AuthorizationInfo getAuthorizationInfo() {
        AuthorizationInfo bai = null;
        ApplicationPolicy ap = this.getBaseApplicationPolicy();
        if (ap != null) {
            bai = ap.getAuthorizationInfo();
        }
        if (bai != null && this.authorizationInfo == null) {
            return bai;
        }
        if (bai != null) {
            return (AuthorizationInfo)this.authorizationInfo.merge(bai);
        }
        return this.authorizationInfo;
    }

    public void setAuthorizationInfo(AuthorizationInfo authorizationInfo) {
        this.authorizationInfo = authorizationInfo;
    }

    public MappingInfo getRoleMappingInfo() {
        MappingInfo bai = null;
        ApplicationPolicy ap = this.getBaseApplicationPolicy();
        if (ap != null) {
            bai = ap.getRoleMappingInfo();
        }
        if (bai != null && this.roleMappingInfo == null) {
            return bai;
        }
        if (bai != null) {
            return (MappingInfo)this.roleMappingInfo.merge(bai);
        }
        return this.roleMappingInfo;
    }

    public void setRoleMappingInfo(MappingInfo roleMappingInfo) {
        this.roleMappingInfo = roleMappingInfo;
    }

    public MappingInfo getPrincipalMappingInfo() {
        MappingInfo bai = null;
        ApplicationPolicy ap = this.getBaseApplicationPolicy();
        if (ap != null) {
            bai = ap.getPrincipalMappingInfo();
        }
        if (bai != null && this.principalMappingInfo == null) {
            return bai;
        }
        if (bai != null) {
            return (MappingInfo)this.principalMappingInfo.merge(bai);
        }
        return this.principalMappingInfo;
    }

    public void setPrincipalMappingInfo(MappingInfo principalMappingInfo) {
        this.principalMappingInfo = principalMappingInfo;
    }

    public <T> MappingInfo getMappingInfo(Class<T> t) {
        if (t == RoleGroup.class) {
            return this.getRoleMappingInfo();
        }
        if (t == Principal.class) {
            return this.getPrincipalMappingInfo();
        }
        throw new IllegalStateException("No mapping information available for type:" + t);
    }

    public AuditInfo getAuditInfo() {
        AuditInfo bai = null;
        ApplicationPolicy ap = this.getBaseApplicationPolicy();
        if (ap != null) {
            bai = ap.getAuditInfo();
        }
        if (bai != null && this.auditInfo == null) {
            return bai;
        }
        if (bai != null) {
            return (AuditInfo)this.auditInfo.merge(bai);
        }
        return this.auditInfo;
    }

    public void setAuditInfo(AuditInfo auditInfo) {
        this.auditInfo = auditInfo;
    }

    public IdentityTrustInfo getIdentityTrustInfo() {
        IdentityTrustInfo bai = null;
        ApplicationPolicy ap = this.getBaseApplicationPolicy();
        if (ap != null) {
            bai = ap.getIdentityTrustInfo();
        }
        if (bai != null && this.identityTrustInfo == null) {
            return bai;
        }
        if (bai != null) {
            return (IdentityTrustInfo)this.identityTrustInfo.merge(bai);
        }
        return this.identityTrustInfo;
    }

    public void setIdentityTrustInfo(IdentityTrustInfo identityTrustInfo) {
        this.identityTrustInfo = identityTrustInfo;
    }

    public String getBaseApplicationPolicyName() {
        return this.baseApplicationPolicyName;
    }

    public void setBaseApplicationPolicyName(String baseApplicationPolicy) {
        this.baseApplicationPolicyName = baseApplicationPolicy;
    }

    public String getName() {
        return this.name;
    }

    public PolicyConfig getPolicyConfig() {
        return this.policyConfig;
    }

    public void setPolicyConfig(PolicyConfig policyConfig) {
        this.policyConfig = policyConfig;
    }

    private ApplicationPolicy getBaseApplicationPolicy() {
        ApplicationPolicy ap = null;
        if (this.baseApplicationPolicyName != null && (ap = this.policyConfig.get(this.baseApplicationPolicyName)) == null) {
            ap = SecurityConfiguration.getApplicationPolicy(this.baseApplicationPolicyName);
        }
        return ap;
    }
}

