/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.security.SecurityContext;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.container.modules.DelegatingServerAuthModule;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.message.config.JBossServerAuthContext;
import org.jboss.security.auth.message.config.SecurityActions;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.SecurityConfiguration;

public class JBossServerAuthConfig
implements ServerAuthConfig {
    private String layer;
    private String contextId;
    private CallbackHandler callbackHandler;
    private List modules = new ArrayList();
    private Map contextProperties;

    public JBossServerAuthConfig(String layer, String appContext, CallbackHandler handler, Map properties) {
        this.layer = layer;
        this.contextId = appContext;
        this.callbackHandler = handler;
        this.contextProperties = properties;
    }

    public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
        ArrayList<ControlFlag> controlFlags = new ArrayList<ControlFlag>();
        HashMap<String, Map> mapOptionsByName = new HashMap<String, Map>();
        SecurityContext securityContext = SecurityActions.getSecurityContext();
        if (securityContext == null) {
            throw new IllegalStateException("Security Context is null");
        }
        String secDomain = securityContext.getSecurityDomain();
        String defaultAppDomain = "other";
        ApplicationPolicy ap = SecurityConfiguration.getApplicationPolicy(secDomain);
        if (ap == null) {
            ap = SecurityConfiguration.getApplicationPolicy(defaultAppDomain);
        }
        if (ap == null) {
            throw new IllegalStateException("No Application Policy found");
        }
        BaseAuthenticationInfo bai = ap.getAuthenticationInfo();
        if (bai == null) {
            throw new IllegalStateException("Authentication Info not set in security domain=" + secDomain + " or " + defaultAppDomain);
        }
        if (bai instanceof AuthenticationInfo) {
            DelegatingServerAuthModule sam = new DelegatingServerAuthModule();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("javax.security.auth.login.LoginContext", secDomain);
            sam.initialize(null, null, new SecurityAssociationHandler(), options);
            this.modules.add(sam);
        } else {
            AuthModuleEntry[] amearr;
            JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
            for (AuthModuleEntry ame : amearr = jai.getAuthModuleEntry()) {
                if (ame.getLoginModuleStackHolderName() != null) {
                    try {
                        mapOptionsByName.put(ame.getAuthModuleName(), ame.getOptions());
                        controlFlags.add(ame.getControlFlag());
                        this.modules.add(this.createSAM(ame.getAuthModuleName(), ame.getLoginModuleStackHolderName()));
                        continue;
                    }
                    catch (Exception e) {
                        throw new AuthException(e.getLocalizedMessage());
                    }
                }
                try {
                    mapOptionsByName.put(ame.getAuthModuleName(), ame.getOptions());
                    controlFlags.add(ame.getControlFlag());
                    this.modules.add(this.createSAM(ame.getAuthModuleName()));
                }
                catch (Exception e) {
                    throw new AuthException(e.getLocalizedMessage());
                }
            }
        }
        JBossServerAuthContext serverAuthContext = new JBossServerAuthContext(this.modules, mapOptionsByName, this.callbackHandler);
        serverAuthContext.setControlFlags(controlFlags);
        return serverAuthContext;
    }

    public String getAppContext() {
        return this.contextId;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public void refresh() throws AuthException, SecurityException {
    }

    public List getServerAuthModules() {
        return this.modules;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return this.contextId;
    }

    public boolean isProtected() {
        throw new RuntimeException("Not Implemented");
    }

    private ServerAuthModule createSAM(String name) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(name);
        Constructor<?> ctr = clazz.getConstructor(new Class[0]);
        return (ServerAuthModule)ctr.newInstance(new Object[0]);
    }

    private ServerAuthModule createSAM(String name, String lmshName) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(name);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (ServerAuthModule)ctr.newInstance(lmshName);
    }
}

