/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.javaee;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAuthorizationHelper
extends AbstractWebAuthorizationHelper {
    protected static Logger log = Logger.getLogger(WebAuthorizationHelper.class);

    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, String contextID, String canonicalRequestURI) {
        boolean isAuthorized;
        block10: {
            if (contextID == null) {
                throw new IllegalArgumentException("ContextID is null");
            }
            if (callerSubject == null) {
                throw new IllegalArgumentException("callerSubject is null");
            }
            if (request == null) {
                throw new IllegalArgumentException("request is null");
            }
            if (response == null) {
                throw new IllegalArgumentException("response is null");
            }
            if (canonicalRequestURI == null) {
                throw new IllegalArgumentException("canonicalRequestURI is null");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw new IllegalStateException("Authorization Manager is null");
            }
            isAuthorized = false;
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(contextID);
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            webResource.setCanonicalRequestURI(canonicalRequestURI);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = authzMgr.getSubjectRoles(callerSubject, (CallbackHandler)sch);
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                isAuthorized = permit == 1;
                String string = level = permit == 1 ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                isAuthorized = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasResourcePermission check failed:" + e.getLocalizedMessage()), (Throwable)e);
                }
                if (!this.enableAudit) break block10;
                this.authorizationAudit("Error", webResource, (Exception)((Object)e));
            }
        }
        return isAuthorized;
    }

    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, String contextID, Subject callerSubject) {
        boolean hasTheRole;
        block8: {
            if (roleName == null) {
                throw new IllegalArgumentException("roleName is null");
            }
            if (contextID == null) {
                throw new IllegalArgumentException("ContextID is null");
            }
            if (callerSubject == null) {
                throw new IllegalArgumentException("callerSubject is null");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw new IllegalStateException("Authorization Manager is null");
            }
            hasTheRole = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleName", roleName);
            map.put("roleRefPermissionCheck", Boolean.TRUE);
            map.put("principal.roles", principalRoles);
            map.put("policyRegistration", this.getPolicyRegistration());
            WebResource webResource = new WebResource(Collections.unmodifiableMap(map));
            webResource.setPolicyContextID(contextID);
            webResource.setPrincipal(principal);
            webResource.setServletName(servletName);
            webResource.setCallerSubject(callerSubject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = authzMgr.getSubjectRoles(callerSubject, (CallbackHandler)sch);
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                hasTheRole = permit == 1;
                String string = level = hasTheRole ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasTheRole = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasRole check failed:" + e.getLocalizedMessage()), (Throwable)e);
                }
                if (!this.enableAudit) break block8;
                this.authorizationAudit("Error", webResource, (Exception)((Object)e));
            }
        }
        return hasTheRole;
    }

    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, String contextID, Subject callerSubject) {
        boolean hasPerm;
        block9: {
            if (contextID == null) {
                throw new IllegalArgumentException("ContextID is null");
            }
            if (callerSubject == null) {
                throw new IllegalArgumentException("callerSubject is null");
            }
            if (request == null) {
                throw new IllegalArgumentException("request is null");
            }
            if (response == null) {
                throw new IllegalArgumentException("response is null");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw new IllegalStateException("Authorization Manager is null");
            }
            hasPerm = false;
            contextMap.put("policyRegistration", this.getPolicyRegistration());
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(contextID);
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = authzMgr.getSubjectRoles(callerSubject, (CallbackHandler)sch);
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                hasPerm = permit == 1;
                String string = level = hasPerm ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasPerm = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasRole check failed:" + e.getLocalizedMessage()), (Throwable)e);
                }
                if (!this.enableAudit) break block9;
                this.authorizationAudit("Error", webResource, (Exception)((Object)e));
            }
        }
        return hasPerm;
    }
}

