/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.mapping.providers;
 
import java.security.Principal;
import java.security.acl.Group; 
import java.util.Map;
import java.util.Properties;
import java.util.Set; 

import org.jboss.logging.Logger;
import org.jboss.security.SecurityConstants;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;


/**
 *  A principal to role mapping provider  
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @version $Revision$
 *  @since  Sep 27, 2006
 */
public class PrincipalToRoleMappingProvider implements MappingProvider<Group>
{
   private static final Logger log = Logger.getLogger(PrincipalToRoleMappingProvider.class);

   //Standard Strings 
   private static final String PRINCIPAL_ROLES_MAP = "principalRolesMap";

   private Map options = null;
   private MappingResult<Group> result;

   private Properties principalRoleMapProperties = null;
 
   public void init(Map opt)
   {
      this.options = opt;
      if(log.isTraceEnabled())
         log.trace("Module Options="+options);
      if(options != null)
      { 
         if(options.containsKey(PRINCIPAL_ROLES_MAP))
         {
            principalRoleMapProperties = (Properties)options.get(PRINCIPAL_ROLES_MAP);
         } 
      } 
   }
   
   public void setMappingResult(MappingResult res)
   { 
      result = res;
   }

   public void performMapping(Map contextMap, Group mappedObject)
   { 
      Set<Principal> principals = (Set<Principal>) contextMap.get(SecurityConstants.PRINCIPALS_SET_IDENTIFIER);
      for(Principal p:principals)
      {
         String pname = p.getName().trim();
         boolean containsP = principalRoleMapProperties.containsKey(pname);
         log.trace("Principal:"+pname+" is contained in options map:"+containsP);
         if(!containsP) continue; 
         String commaSeparatedRoles = principalRoleMapProperties.getProperty(pname);
         if(log.isTraceEnabled())
            log.trace("Principal:"+p.getName()+":roles add="+commaSeparatedRoles);
         String[] tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles);
         int len = tokens != null ? tokens.length : 0;
         for(int i = 0; i < len; i++)
         {
            mappedObject.addMember(MappingProviderUtil.instantiatePrincipal(p.getClass(),tokens[i]));
         }
      }   
      result.setMappedObject(mappedObject);
   }  
}