/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identitytrust;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identitytrust.IdentityTrustContext;
import org.jboss.security.identitytrust.IdentityTrustException;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.identitytrust.IdentityTrustModule;
import org.jboss.security.identitytrust.SecurityActions;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;

public class JBossIdentityTrustContext
extends IdentityTrustContext {
    protected Logger log = Logger.getLogger(JBossIdentityTrustContext.class);

    public JBossIdentityTrustContext(String secDomain, SecurityContext sc) {
        this.securityDomain = secDomain;
        this.securityContext = sc;
    }

    public IdentityTrustManager.TrustDecision isTrusted() throws IdentityTrustException {
        IdentityTrustManager.TrustDecision decision = this.NOTAPPLICABLE;
        try {
            this.initializeModules();
        }
        catch (Exception e) {
            throw new IdentityTrustException((Throwable)e);
        }
        try {
            decision = AccessController.doPrivileged(new PrivilegedExceptionAction<IdentityTrustManager.TrustDecision>(){

                @Override
                public IdentityTrustManager.TrustDecision run() throws IdentityTrustException {
                    IdentityTrustManager.TrustDecision result = JBossIdentityTrustContext.this.invokeTrusted();
                    if (result == JBossIdentityTrustContext.this.PERMIT) {
                        JBossIdentityTrustContext.this.invokeCommit();
                    }
                    if (result == JBossIdentityTrustContext.this.DENY || result == JBossIdentityTrustContext.this.NOTAPPLICABLE) {
                        JBossIdentityTrustContext.this.invokeAbort();
                    }
                    return result;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exc = e.getException();
            this.log.trace((Object)"Error in isAuthorize:", (Throwable)exc);
            this.invokeAbort();
            throw (IdentityTrustException)exc;
        }
        return decision;
    }

    private void initializeModules() throws Exception {
        IdentityTrustModuleEntry[] itmearr;
        this.modules.clear();
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (aPolicy == null) {
            throw new IllegalStateException("ApplicationPolicy not found for " + this.securityDomain);
        }
        IdentityTrustInfo iti = aPolicy.getIdentityTrustInfo();
        if (iti == null) {
            return;
        }
        for (IdentityTrustModuleEntry itme : itmearr = iti.getIdentityTrustModuleEntry()) {
            ControlFlag cf = itme.getControlFlag();
            if (cf == null) {
                cf = ControlFlag.REQUIRED;
            }
            this.controlFlags.add(cf);
            this.modules.add(this.instantiateModule(itme.getName(), itme.getOptions()));
        }
    }

    private IdentityTrustModule instantiateModule(String name, Map map) throws Exception {
        IdentityTrustModule im = null;
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        try {
            Class<?> clazz = tcl.loadClass(name);
            im = (IdentityTrustModule)clazz.newInstance();
        }
        catch (Exception e) {
            this.log.debug((Object)"Error instantiating IdentityTrustModule:", (Throwable)e);
        }
        if (im == null) {
            throw new IllegalStateException("IdentityTrustModule has not been instantiated");
        }
        im.initialize(this.securityContext, this.callbackHandler, this.sharedState, map);
        return im;
    }

    private IdentityTrustManager.TrustDecision invokeTrusted() throws IdentityTrustException {
        boolean encounteredRequiredDeny = false;
        boolean encounteredRequiredNotApplicable = false;
        boolean encounteredOptionalError = false;
        IdentityTrustException moduleException = null;
        IdentityTrustManager.TrustDecision overallDecision = IdentityTrustManager.TrustDecision.NotApplicable;
        boolean encounteredRequiredPermit = false;
        IdentityTrustManager.TrustDecision decision = this.NOTAPPLICABLE;
        int length = this.modules.size();
        if (length == 0) {
            return decision;
        }
        for (int i = 0; i < length; ++i) {
            ControlFlag flag;
            IdentityTrustModule module;
            block15: {
                module = (IdentityTrustModule)this.modules.get(i);
                flag = (ControlFlag)this.controlFlags.get(i);
                try {
                    decision = module.isTrusted();
                }
                catch (Exception ae) {
                    decision = this.NOTAPPLICABLE;
                    if (moduleException != null) break block15;
                    moduleException = new IdentityTrustException((Throwable)ae);
                }
            }
            if (decision == this.PERMIT) {
                overallDecision = this.PERMIT;
                if (flag == ControlFlag.REQUIRED) {
                    encounteredRequiredPermit = true;
                }
                if (flag != ControlFlag.SUFFICIENT || encounteredRequiredDeny) continue;
                return this.PERMIT;
            }
            if (decision == this.NOTAPPLICABLE && flag == ControlFlag.REQUIRED) {
                encounteredRequiredNotApplicable = true;
                continue;
            }
            if (flag == ControlFlag.REQUISITE) {
                this.log.trace((Object)("REQUISITE failed for " + module));
                if (moduleException == null) {
                    moduleException = new IdentityTrustException("Identity Trust Validation failed");
                } else {
                    throw moduleException;
                }
            }
            if (flag == ControlFlag.REQUIRED) {
                this.log.trace((Object)("REQUIRED failed for " + module));
                encounteredRequiredDeny = true;
            }
            if (flag != ControlFlag.OPTIONAL) continue;
            encounteredOptionalError = true;
        }
        if (encounteredRequiredDeny) {
            return this.DENY;
        }
        if (overallDecision == this.DENY && encounteredOptionalError) {
            return this.DENY;
        }
        if (overallDecision == this.DENY) {
            return this.DENY;
        }
        if (encounteredRequiredNotApplicable && !encounteredRequiredPermit) {
            return this.NOTAPPLICABLE;
        }
        return this.PERMIT;
    }

    private void invokeCommit() throws IdentityTrustException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
            boolean bool = module.commit();
            if (bool) continue;
            throw new IdentityTrustException("commit on modules failed");
        }
    }

    private void invokeAbort() throws IdentityTrustException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            IdentityTrustModule module = (IdentityTrustModule)this.modules.get(i);
            boolean bool = module.abort();
            if (bool) continue;
            throw new IdentityTrustException("abort on modules failed");
        }
    }
}

