/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.DecodeAction;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapLoginModule
extends UsernamePasswordLoginModule {
    private static final String PRINCIPAL_DN_PREFIX_OPT = "principalDNPrefix";
    private static final String PRINCIPAL_DN_SUFFIX_OPT = "principalDNSuffix";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT = "userRolesCtxDNAttributeName";
    private static final String UID_ATTRIBUTE_ID_OPT = "uidAttributeID";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String MATCH_ON_USER_DN_OPT = "matchOnUserDN";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    private static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"principalDNPrefix", "principalDNSuffix", "rolesCtxDN", "userRolesCtxDNAttributeName", "uidAttributeID", "roleAttributeID", "matchOnUserDN", "roleAttributeIsDN", "roleNameAttributeID", "searchTimeLimit", "searchScope", "jaasSecurityDomain", "allowEmptyPasswords", "java.naming.factory.initial", "java.naming.security.authentication", "java.naming.security.protocol", "java.naming.provider.url", "java.naming.security.principal", "java.naming.security.credentials"};
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        return "";
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    @Override
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean trace = this.log.isTraceEnabled();
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = true;
                String flag = (String)this.options.get(ALLOW_EMPTY_PASSWORDS);
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    if (trace) {
                        this.log.trace((Object)"Rejecting empty password due to allowEmptyPasswords");
                    }
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                this.createLdapInitContext(username, inputPassword);
                isValid = true;
            }
            catch (Throwable e) {
                super.setValidateError(e);
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLdapInitContext(String username, Object credential) throws Exception {
        block50: {
            String principalDNSuffix;
            String principalDNPrefix;
            String authType;
            boolean trace = this.log.isTraceEnabled();
            Properties env = new Properties();
            for (Map.Entry entry : this.options.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
            String factoryName = env.getProperty("java.naming.factory.initial");
            if (factoryName == null) {
                factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
                env.setProperty("java.naming.factory.initial", factoryName);
            }
            if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
                env.setProperty("java.naming.security.authentication", "simple");
            }
            String protocol = env.getProperty("java.naming.security.protocol");
            String providerURL = (String)this.options.get("java.naming.provider.url");
            if (providerURL == null) {
                providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
            }
            String bindDN = (String)this.options.get("java.naming.security.principal");
            String bindCredential = (String)this.options.get("java.naming.security.credentials");
            String securityDomain = (String)this.options.get(SECURITY_DOMAIN_OPT);
            if (securityDomain != null) {
                ObjectName serviceName = new ObjectName(securityDomain);
                char[] tmp = DecodeAction.decode(bindCredential, serviceName);
                bindCredential = new String(tmp);
            }
            if ((principalDNPrefix = (String)this.options.get(PRINCIPAL_DN_PREFIX_OPT)) == null) {
                principalDNPrefix = "";
            }
            if ((principalDNSuffix = (String)this.options.get(PRINCIPAL_DN_SUFFIX_OPT)) == null) {
                principalDNSuffix = "";
            }
            String matchType = (String)this.options.get(MATCH_ON_USER_DN_OPT);
            boolean matchOnUserDN = Boolean.valueOf(matchType);
            String userDN = principalDNPrefix + username + principalDNSuffix;
            env.setProperty("java.naming.provider.url", providerURL);
            env.setProperty("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", credential);
            if (trace) {
                Properties tmp = new Properties();
                tmp.putAll((Map<?, ?>)env);
                tmp.setProperty("java.naming.security.credentials", "***");
                if (trace) {
                    this.log.trace((Object)("Logging into LDAP server, env=" + tmp.toString()));
                }
            }
            InitialLdapContext ctx = null;
            try {
                String scope;
                int searchTimeLimit;
                int searchScope;
                String roleNameAttributeID;
                boolean roleAttributeIsDN;
                Object[] roleAttr;
                String userToMatch;
                StringBuffer roleFilter;
                String roleAttrName;
                String rolesCtxDN;
                block51: {
                    block49: {
                        ctx = new InitialLdapContext(env, null);
                        if (trace) {
                            this.log.trace((Object)("Logged into LDAP server, " + ctx));
                        }
                        if (bindDN != null) {
                            if (trace) {
                                this.log.trace((Object)("Rebind SECURITY_PRINCIPAL to: " + bindDN));
                            }
                            env.setProperty("java.naming.security.principal", bindDN);
                            env.put("java.naming.security.credentials", bindCredential);
                            ctx = new InitialLdapContext(env, null);
                        }
                        rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
                        String userRolesCtxDNAttributeName = (String)this.options.get(USER_ROLES_CTX_DN_ATTRIBUTE_ID_OPT);
                        if (userRolesCtxDNAttributeName != null) {
                            String[] returnAttribute = new String[]{userRolesCtxDNAttributeName};
                            try {
                                Attributes result = ctx.getAttributes(userDN, returnAttribute);
                                if (result.get(userRolesCtxDNAttributeName) != null) {
                                    rolesCtxDN = result.get(userRolesCtxDNAttributeName).get().toString();
                                    if (trace) {
                                        this.log.trace((Object)("Found user roles context DN: " + rolesCtxDN));
                                    }
                                }
                            }
                            catch (NamingException e) {
                                if (!trace) break block49;
                                this.log.debug((Object)"Failed to query userRolesCtxDNAttributeName", (Throwable)e);
                            }
                        }
                    }
                    if (rolesCtxDN == null) break block50;
                    String uidAttrName = (String)this.options.get(UID_ATTRIBUTE_ID_OPT);
                    if (uidAttrName == null) {
                        uidAttrName = "uid";
                    }
                    if ((roleAttrName = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT)) == null) {
                        roleAttrName = "roles";
                    }
                    roleFilter = new StringBuffer("(");
                    roleFilter.append(uidAttrName);
                    roleFilter.append("={0})");
                    userToMatch = username;
                    if (matchOnUserDN) {
                        userToMatch = userDN;
                    }
                    roleAttr = new String[]{roleAttrName};
                    String roleAttributeIsDNOption = (String)this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
                    roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
                    roleNameAttributeID = (String)this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
                    if (roleNameAttributeID == null) {
                        roleNameAttributeID = "name";
                    }
                    searchScope = 2;
                    searchTimeLimit = 10000;
                    String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
                    if (timeLimit != null) {
                        try {
                            searchTimeLimit = Integer.parseInt(timeLimit);
                        }
                        catch (NumberFormatException e) {
                            if (!trace) break block51;
                            this.log.trace((Object)("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + searchTimeLimit), (Throwable)e);
                        }
                    }
                }
                if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)this.options.get(SEARCH_SCOPE_OPT))) {
                    searchScope = 0;
                } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                    searchScope = 1;
                }
                if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                    searchScope = 2;
                }
                NamingEnumeration<SearchResult> answer = null;
                try {
                    SearchControls controls = new SearchControls();
                    controls.setSearchScope(searchScope);
                    controls.setReturningAttributes((String[])roleAttr);
                    controls.setTimeLimit(searchTimeLimit);
                    Object[] filterArgs = new Object[]{userToMatch};
                    if (trace) {
                        this.log.trace((Object)("searching rolesCtxDN=" + rolesCtxDN + ", roleFilter=" + roleFilter + ", filterArgs=" + userToMatch + ", roleAttr=" + Arrays.toString(roleAttr) + ", searchScope=" + searchScope + ", searchTimeLimit=" + searchTimeLimit));
                    }
                    answer = ctx.search(rolesCtxDN, roleFilter.toString(), filterArgs, controls);
                    while (answer.hasMore()) {
                        Attributes attrs;
                        Attribute roles;
                        SearchResult sr = answer.next();
                        if (trace) {
                            this.log.trace((Object)("Checking answer: " + sr.getName()));
                        }
                        if ((roles = (attrs = sr.getAttributes()).get(roleAttrName)) != null) {
                            for (int r = 0; r < roles.size(); ++r) {
                                Object value = roles.get(r);
                                String roleName = null;
                                if (roleAttributeIsDN) {
                                    String roleDN = value.toString();
                                    String[] returnAttribute = new String[]{roleNameAttributeID};
                                    if (trace) {
                                        this.log.trace((Object)("Following roleDN: " + roleDN));
                                    }
                                    try {
                                        Attributes result2 = ctx.getAttributes(roleDN, returnAttribute);
                                        Attribute roles2 = result2.get(roleNameAttributeID);
                                        if (roles2 == null) continue;
                                        for (int m = 0; m < roles2.size(); ++m) {
                                            roleName = (String)roles2.get(m);
                                            this.addRole(roleName);
                                        }
                                        continue;
                                    }
                                    catch (NamingException e) {
                                        if (!trace) continue;
                                        this.log.trace((Object)"Failed to query roleNameAttrName", (Throwable)e);
                                        continue;
                                    }
                                }
                                roleName = value.toString();
                                this.addRole(roleName);
                            }
                            continue;
                        }
                        if (!trace) continue;
                        this.log.trace((Object)("No attribute " + roleAttrName + " found in " + sr.getName()));
                    }
                }
                catch (NamingException e) {
                    if (trace) {
                        this.log.trace((Object)"Failed to locate roles", (Throwable)e);
                    }
                }
                finally {
                    if (answer != null) {
                        answer.close();
                    }
                }
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
    }

    private void addRole(String roleName) {
        boolean trace = this.log.isTraceEnabled();
        if (roleName != null) {
            try {
                Principal p = super.createIdentity(roleName);
                if (trace) {
                    this.log.trace((Object)("Assign user to role " + roleName));
                }
                this.userRoles.addMember(p);
            }
            catch (Exception e) {
                this.log.debug((Object)("Failed to create principal: " + roleName), (Throwable)e);
            }
        }
    }
}

