/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.jboss.security.PushPermission;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlContextManipulator {
    private static final Logger log = Logger.getLogger(AccessControlContextManipulator.class);
    private static final AccessControlContext CONTEXT_EMPTY = new AccessControlContext(new ProtectionDomain[0]);
    private static final ThreadLocal<LinkedList<ProtectionDomain>> THREAD_DOMAINS = new ThreadLocal();
    private static final ThreadLocal<AccessControlContext> THREAD_CONTEXT = new ThreadLocal();

    public static void pushContext(VirtualFile file) throws MalformedURLException, IOException, URISyntaxException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(new PushPermission());
        VirtualFile pf = file.getParent();
        VirtualFile root = null;
        root = pf.getPathName().endsWith("META-INF") || pf.getPathName().endsWith("META-INF/") ? pf.getParent() : file;
        URL realRootURL = VFSUtils.getRealURL((VirtualFile)root);
        AccessControlContextManipulator.pushContext(realRootURL.toURI());
    }

    public static void pushContext(URI uri) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || Policy.getPolicy() == null) {
            return;
        }
        sm.checkPermission(new PushPermission());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Pushing " + uri + " to context."));
        }
        AccessControlContextManipulator.initThreadLocal();
        ProtectionDomain protectionDomain = null;
        CodeSource codeSource = new CodeSource(uri.toURL(), (Certificate[])null);
        PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
        protectionDomain = new ProtectionDomain(codeSource, permissionCollection);
        THREAD_DOMAINS.get().addLast(protectionDomain);
        THREAD_CONTEXT.set(null);
    }

    public static void popContext() {
        if (System.getSecurityManager() == null || Policy.getPolicy() == null) {
            return;
        }
        AccessControlContextManipulator.initThreadLocal();
        log.trace((Object)"Poping from context");
        LinkedList<ProtectionDomain> list = THREAD_DOMAINS.get();
        if (list.isEmpty()) {
            return;
        }
        THREAD_DOMAINS.get().removeLast();
        THREAD_CONTEXT.set(null);
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action, AccessControlContextManipulator.getCurrentContext());
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return AccessController.doPrivileged(action, AccessControlContextManipulator.getCurrentContext());
    }

    private static AccessControlContext getCurrentContext() {
        boolean trace = log.isTraceEnabled();
        AccessControlContext context = THREAD_CONTEXT.get();
        if (context != null) {
            if (trace) {
                log.trace((Object)("returning context directly " + context));
            }
            return context;
        }
        LinkedList<ProtectionDomain> protectionDomains = THREAD_DOMAINS.get();
        if (protectionDomains == null || protectionDomains.isEmpty()) {
            if (trace) {
                log.trace((Object)"returning empty context");
            }
            return CONTEXT_EMPTY;
        }
        if (trace) {
            int i = 0;
            for (ProtectionDomain p : protectionDomains) {
                log.trace((Object)(i++ + ". PD = " + p));
            }
        }
        ProtectionDomain[] protectionDomainsArray = new ProtectionDomain[protectionDomains.size()];
        protectionDomainsArray = protectionDomains.toArray(protectionDomainsArray);
        context = new AccessControlContext(protectionDomainsArray);
        THREAD_CONTEXT.set(context);
        return context;
    }

    private static void initThreadLocal() {
        if (THREAD_DOMAINS.get() == null) {
            THREAD_DOMAINS.set(new LinkedList());
        }
    }
}

