/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.vault;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.plugins.PBEUtils;
import org.jboss.security.plugins.vault.SecurityVaultData;
import org.jboss.security.util.EncryptionUtil;
import org.jboss.security.util.KeyStoreUtil;
import org.jboss.security.util.StringUtil;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicketBoxSecurityVault
implements SecurityVault {
    protected boolean finishedInit = false;
    protected KeyStore keystore = null;
    protected String encryptionAlgorithm = "AES";
    protected int keySize = 128;
    private char[] keyStorePWD = null;
    private String alias = null;
    private SecurityVaultData vaultContent = null;
    private SecretKey adminKey;
    private String decodedEncFileDir;
    private boolean createKeyStore = false;
    private String keyStoreType = "JCEKS";
    public static final String ENC_FILE_DIR = "ENC_FILE_DIR";
    public static final String KEYSTORE_URL = "KEYSTORE_URL";
    public static final String KEYSTORE_PASSWORD = "KEYSTORE_PASSWORD";
    public static final String KEYSTORE_ALIAS = "KEYSTORE_ALIAS";
    public static final String SALT = "SALT";
    public static final String ITERATION_COUNT = "ITERATION_COUNT";
    public static final String PASS_MASK_PREFIX = "MASK-";
    public static final String PUBLIC_CERT = "PUBLIC_CERT";
    public static final String KEY_SIZE = "KEY_SIZE";
    public static final String CREATE_KEYSTORE = "CREATE_KEYSTORE";
    public static final String KEYSTORE_TYPE = "KEYSTORE_TYPE";
    private static final String ENCODED_FILE = "ENC.dat";
    private static final String SHARED_KEY_FILE = "Shared.dat";
    private static final String ADMIN_KEY = "ADMIN_KEY";
    protected static final String VAULT_CONTENT_FILE = "VAULT.dat";
    protected static final String defaultKeyStoreType = "JCEKS";
    private static final Logger log = Logger.getLogger(PicketBoxSecurityVault.class);

    public void init(Map<String, Object> options) throws SecurityVaultException {
        String encFileDir;
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("Options map options is null or empty");
        }
        String keystoreURL = (String)options.get(KEYSTORE_URL);
        if (keystoreURL == null) {
            throw new SecurityVaultException("Option KEYSTORE_URLis null or empty");
        }
        if (keystoreURL.contains("${")) {
            keystoreURL = keystoreURL.replaceAll(":", "::");
        }
        keystoreURL = StringUtil.getSystemPropertyAsString(keystoreURL);
        String password = (String)options.get(KEYSTORE_PASSWORD);
        if (password == null) {
            throw new SecurityVaultException("Option KEYSTORE_PASSWORDis null or empty");
        }
        if (!password.startsWith(PASS_MASK_PREFIX) && !Util.isPasswordCommand(password)) {
            throw new SecurityVaultException("Keystore password should be either masked or prefixed with one of {EXT}, {EXTC}, {CMD}, {CMDC}, {CLASS}");
        }
        String salt = (String)options.get(SALT);
        if (salt == null) {
            throw new SecurityVaultException("Option SALTis null or empty");
        }
        String iterationCountStr = (String)options.get(ITERATION_COUNT);
        if (iterationCountStr == null) {
            throw new SecurityVaultException("Option ITERATION_COUNTis null or empty");
        }
        int iterationCount = Integer.parseInt(iterationCountStr);
        this.alias = (String)options.get(KEYSTORE_ALIAS);
        if (this.alias == null) {
            throw new SecurityVaultException("Option KEYSTORE_ALIASis null or empty");
        }
        String keySizeStr = (String)options.get(KEY_SIZE);
        if (keySizeStr != null) {
            this.keySize = Integer.parseInt(keySizeStr);
        }
        if ((encFileDir = (String)options.get(ENC_FILE_DIR)) == null) {
            throw new SecurityVaultException("Option ENC_FILE_DIRis null or empty");
        }
        this.createKeyStore = options.get(CREATE_KEYSTORE) != null ? Boolean.parseBoolean((String)options.get(CREATE_KEYSTORE)) : this.createKeyStore;
        this.keyStoreType = options.get(KEYSTORE_TYPE) != null ? (String)options.get(KEYSTORE_TYPE) : defaultKeyStoreType;
        try {
            this.keyStorePWD = this.loadKeystorePassword(password, salt, iterationCount);
            this.keystore = this.getKeyStore(keystoreURL);
            this.checkAndConvertKeyStoreToJCEKS(keystoreURL);
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
        this.readVaultContent(keystoreURL, encFileDir);
        log.debug((Object)"Default Security Vault Implementation Initialized and Ready");
        this.finishedInit = true;
    }

    public boolean isInitialized() {
        return this.finishedInit;
    }

    public byte[] handshake(Map<String, Object> handshakeOptions) throws SecurityVaultException {
        return new byte[this.keySize];
    }

    public Set<String> keyList() throws SecurityVaultException {
        return this.vaultContent.getVaultDataKeys();
    }

    public void store(String vaultBlock, String attributeName, char[] attributeValue, byte[] sharedKey) throws SecurityVaultException {
        if (StringUtil.isNullOrEmpty(vaultBlock)) {
            throw new IllegalArgumentException("Argument vaultBlock cannot be null");
        }
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw new IllegalArgumentException("Argument attributeName cannot be null");
        }
        String av = new String(attributeValue);
        EncryptionUtil util = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        try {
            SecretKeySpec sKeySpec = new SecretKeySpec(this.adminKey.getEncoded(), this.encryptionAlgorithm);
            byte[] encryptedData = util.encrypt(av.getBytes(), sKeySpec);
            this.vaultContent.addVaultData(this.alias, vaultBlock, attributeName, encryptedData);
        }
        catch (Exception e1) {
            throw new SecurityVaultException("Unable to encrypt data", (Throwable)e1);
        }
        try {
            this.writeVaultData();
        }
        catch (IOException e) {
            throw new SecurityVaultException("Unable to write vault data file VAULT_CONTENT_FILE", (Throwable)e);
        }
    }

    public char[] retrieve(String vaultBlock, String attributeName, byte[] sharedKey) throws SecurityVaultException {
        if (StringUtil.isNullOrEmpty(vaultBlock)) {
            throw new IllegalArgumentException("Argument vaultBlock cannot be null");
        }
        if (StringUtil.isNullOrEmpty(attributeName)) {
            throw new IllegalArgumentException("Argument attributeName cannot be null");
        }
        byte[] encryptedValue = this.vaultContent.getVaultData(this.alias, vaultBlock, attributeName);
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.adminKey.getEncoded(), this.encryptionAlgorithm);
        EncryptionUtil encUtil = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
        try {
            return new String(encUtil.decrypt(encryptedValue, secretKeySpec)).toCharArray();
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
    }

    public boolean exists(String vaultBlock, String attributeName) throws SecurityVaultException {
        return this.vaultContent.getVaultData(this.alias, vaultBlock, attributeName) != null;
    }

    public boolean remove(String vaultBlock, String attributeName, byte[] sharedKey) throws SecurityVaultException {
        try {
            this.vaultContent.deleteVaultData(this.alias, vaultBlock, attributeName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private char[] loadKeystorePassword(String passwordDef, String salt, int iterationCount) throws Exception {
        char[] password;
        if (passwordDef.startsWith(PASS_MASK_PREFIX)) {
            String keystorePass = this.decode(passwordDef, salt, iterationCount);
            password = keystorePass.toCharArray();
        } else {
            password = Util.loadPassword(passwordDef);
        }
        return password;
    }

    private String decode(String maskedString, String salt, int iterationCount) throws Exception {
        String pbeAlgo = "PBEwithMD5andDES";
        if (maskedString.startsWith(PASS_MASK_PREFIX)) {
            String decodedValue;
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
            char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            maskedString = maskedString.substring(PASS_MASK_PREFIX.length());
            maskedString = decodedValue = PBEUtils.decode64(maskedString, pbeAlgo, cipherKey, cipherSpec);
        }
        return maskedString;
    }

    private void setUpVault(String keystoreURL, String decodedEncFileDir) throws NoSuchAlgorithmException, IOException {
        this.vaultContent = new SecurityVaultData();
        this.writeVaultData();
        SecretKey sk = this.getAdminKey();
        if (sk != null) {
            this.adminKey = sk;
        } else {
            EncryptionUtil util = new EncryptionUtil(this.encryptionAlgorithm, this.keySize);
            sk = util.generateKey();
            KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(sk);
            try {
                this.keystore.setEntry(this.alias, skEntry, new KeyStore.PasswordProtection(this.keyStorePWD));
                this.adminKey = sk;
                this.saveKeyStoreToFile(keystoreURL);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("There is no SecretKey under the alias " + this.alias + " and the alias is already used to denote diffrent crypto object in the keystore.");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to store keystore to file " + keystoreURL, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVaultData() throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.decodedEncFileDir + VAULT_CONTENT_FILE);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.vaultContent);
            Object var4_3 = null;
            this.safeClose(oos);
            this.safeClose(fos);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.safeClose(oos);
            this.safeClose(fos);
            throw throwable;
        }
    }

    private boolean vaultFileExists(String fileName) {
        File file = new File(this.decodedEncFileDir + fileName);
        return file != null && file.exists();
    }

    private boolean directoryExists(String dir) {
        File file = new File(dir);
        return file != null && file.exists();
    }

    private void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readVaultContent(String keystoreURL, String encFileDir) throws SecurityVaultException {
        try {
            if (encFileDir.contains("${)")) {
                encFileDir = encFileDir.replaceAll(":", "::");
            }
            this.decodedEncFileDir = StringUtil.getSystemPropertyAsString(encFileDir);
            if (!this.directoryExists(this.decodedEncFileDir)) {
                throw new SecurityVaultException("File or directory " + this.decodedEncFileDir + " does not exist");
            }
            if (!this.decodedEncFileDir.endsWith("/") && !this.decodedEncFileDir.endsWith("\\")) {
                this.decodedEncFileDir = this.decodedEncFileDir + File.separator;
            }
            if (this.vaultFileExists(ENCODED_FILE)) {
                if (this.vaultFileExists(VAULT_CONTENT_FILE)) {
                    log.error((Object)("Security Vault contains both covnerted VAULT.dat and pre-conversion data ENC.dat. Try to delete " + this.decodedEncFileDir + ENCODED_FILE + " file and start over again."));
                    throw new RuntimeException("Security Vault contains both covnerted VAULT.dat and pre-conversion data ENC.dat, failed to load vault");
                }
                this.convertVaultContent(keystoreURL, this.alias);
            } else if (this.vaultFileExists(VAULT_CONTENT_FILE)) {
                this.readVersionedVaultContent();
            } else {
                this.setUpVault(keystoreURL, this.decodedEncFileDir);
            }
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertVaultContent(String keystoreURL, String alias) throws Exception {
        Map theContent;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(this.decodedEncFileDir + ENCODED_FILE);
            ois = new ObjectInputStream(fis);
            theContent = (Map)ois.readObject();
            Object var7_6 = null;
            this.safeClose(fis);
            this.safeClose(ois);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.safeClose(fis);
            this.safeClose(ois);
            throw throwable;
        }
        this.vaultContent = new SecurityVaultData();
        this.adminKey = null;
        for (String key : theContent.keySet()) {
            if (key.equals(ADMIN_KEY)) {
                byte[] admin_key = (byte[])theContent.get(key);
                this.adminKey = new SecretKeySpec(admin_key, this.encryptionAlgorithm);
                continue;
            }
            if (!key.contains("_")) continue;
            StringTokenizer tokenizer = new StringTokenizer(key, "_");
            String vaultBlock = tokenizer.nextToken();
            String attributeName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                attributeName = key.substring(vaultBlock.length() + 1);
                log.info((Object)("Ambiguos vault block and attribute name stored in original security vault. Delimiter _ is part of vault block or attribute name. Took the first delimiter. Result vault block " + vaultBlock + " attribute name " + attributeName + ". Modify security vault manually."));
            }
            byte[] encodedAttributeValue = (byte[])theContent.get(key);
            this.vaultContent.addVaultData(alias, vaultBlock, attributeName, encodedAttributeValue);
        }
        if (this.adminKey == null) {
            throw new RuntimeException("Security Vault conversion unsuccessful missing admin key in original vault data");
        }
        KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(this.adminKey);
        KeyStore.PasswordProtection p = new KeyStore.PasswordProtection(this.keyStorePWD);
        KeyStore.Entry e = this.keystore.getEntry(alias, p);
        if (e != null) {
            String originalAlias = alias + "-original";
            this.keystore.setEntry(originalAlias, e, p);
            this.keystore.deleteEntry(alias);
        }
        this.keystore.setEntry(alias, skEntry, new KeyStore.PasswordProtection(this.keyStorePWD));
        this.saveKeyStoreToFile(keystoreURL);
        PicketBoxSecurityVault.copyFile(new File(this.decodedEncFileDir + ENCODED_FILE), new File(this.decodedEncFileDir + ENCODED_FILE + ".original"));
        this.writeVaultData();
        File f = new File(this.decodedEncFileDir + ENCODED_FILE);
        if (!f.delete()) {
            log.warn((Object)("Cannot delete original security vault file " + f.getCanonicalPath() + ". Delete the file manually before next start, please."));
        }
        if (!(f = new File(this.decodedEncFileDir + SHARED_KEY_FILE)).delete()) {
            log.warn((Object)("Cannot delete original security vault file " + f.getCanonicalPath() + ". Delete the file manually before next start, please."));
        }
    }

    private void saveKeyStoreToFile(String keystoreURL) throws Exception {
        this.keystore.store(new FileOutputStream(new File(keystoreURL)), this.keyStorePWD);
    }

    private void checkAndConvertKeyStoreToJCEKS(String keystoreURL) throws Exception {
        if (this.keystore.getType().equalsIgnoreCase("JKS")) {
            PicketBoxSecurityVault.copyFile(new File(keystoreURL), new File(keystoreURL + ".original"));
            KeyStore jceks = KeyStoreUtil.createKeyStore(defaultKeyStoreType, this.keyStorePWD);
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                String entryAlias = aliases.nextElement();
                KeyStore.PasswordProtection p = new KeyStore.PasswordProtection(this.keyStorePWD);
                KeyStore.Entry e = this.keystore.getEntry(entryAlias, p);
                jceks.setEntry(entryAlias, e, p);
            }
            this.keystore = jceks;
            this.keyStoreType = defaultKeyStoreType;
            this.saveKeyStoreToFile(keystoreURL);
            log.info((Object)"Security Vault key store successfuly converted to JCEKS type KEYSTORE_URL. From now on use JCEKS as KEYSTORE_TYPE in Security Vault configuration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readVersionedVaultContent() throws Exception {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(this.decodedEncFileDir + VAULT_CONTENT_FILE);
            ois = new ObjectInputStream(fis);
            this.vaultContent = (SecurityVaultData)ois.readObject();
            Object var4_3 = null;
            this.safeClose(fis);
            this.safeClose(ois);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.safeClose(fis);
            this.safeClose(ois);
            throw throwable;
        }
        this.adminKey = this.getAdminKey();
        if (this.adminKey == null) {
            throw new RuntimeException("Security Vault does not contain SecretKey entry under alias " + this.alias);
        }
    }

    private SecretKey getAdminKey() {
        try {
            KeyStore.Entry e = this.keystore.getEntry(this.alias, new KeyStore.PasswordProtection(this.keyStorePWD));
            if (e instanceof KeyStore.SecretKeyEntry) {
                return ((KeyStore.SecretKeyEntry)e).getSecretKey();
            }
        }
        catch (Exception e) {
            log.info((Object)("Security Vault does not contain SecretKey entry under alias " + this.alias));
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        AbstractInterruptibleChannel destination;
        FileOutputStream fOut;
        block15: {
            FileInputStream fIn;
            block14: {
                if (!destFile.exists()) {
                    destFile.createNewFile();
                }
                fIn = null;
                fOut = null;
                FileChannel source = null;
                destination = null;
                try {
                    fIn = new FileInputStream(sourceFile);
                    source = fIn.getChannel();
                    fOut = new FileOutputStream(destFile);
                    destination = fOut.getChannel();
                    long transfered = 0L;
                    long bytes = source.size();
                    while (transfered < bytes) {
                        ((FileChannel)destination).position(transfered += ((FileChannel)destination).transferFrom(source, 0L, source.size()));
                    }
                    Object var11_8 = null;
                    if (source == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    if (source != null) {
                        source.close();
                    } else if (fIn != null) {
                        fIn.close();
                    }
                    if (destination != null) {
                        destination.close();
                    } else if (fOut != null) {
                        fOut.close();
                    }
                    throw throwable;
                }
                source.close();
                break block15;
            }
            if (fIn != null) {
                fIn.close();
            }
        }
        if (destination != null) {
            destination.close();
        } else if (fOut != null) {
            fOut.close();
        }
    }

    private KeyStore getKeyStore(String keystoreURL) {
        try {
            return KeyStoreUtil.getKeyStore(this.keyStoreType, keystoreURL, this.keyStorePWD);
        }
        catch (IOException e) {
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to get keystore " + keystoreURL, e);
        }
        try {
            if (this.createKeyStore) {
                return KeyStoreUtil.createKeyStore(this.keyStoreType, this.keyStorePWD);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to get keystore " + keystoreURL, e);
        }
        return null;
    }
}

