/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.security.plugins.PBEUtils;
import org.jboss.security.util.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final String PROPERTY_DEFAULT_SEPARATOR = "::";

    public static boolean isNotNull(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getSystemPropertyAsString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument str cannot be null");
        }
        if (str.contains("${")) {
            Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
            Matcher matcher = pattern.matcher(str);
            StringBuffer buffer = new StringBuffer();
            String sysPropertyValue = null;
            while (matcher.find()) {
                String subString = matcher.group(1);
                String defaultValue = "";
                if (subString.contains(PROPERTY_DEFAULT_SEPARATOR)) {
                    int index = subString.indexOf(PROPERTY_DEFAULT_SEPARATOR);
                    defaultValue = subString.substring(index + PROPERTY_DEFAULT_SEPARATOR.length());
                    subString = subString.substring(0, index);
                }
                if ((sysPropertyValue = SecurityActions.getSystemProperty(subString, defaultValue)).isEmpty()) {
                    throw new IllegalArgumentException("The specified system property " + matcher.group(1) + " is missing");
                }
                matcher.appendReplacement(buffer, sysPropertyValue.replace("\\", "\\\\"));
            }
            matcher.appendTail(buffer);
            str = buffer.toString();
        }
        return str;
    }

    public static void match(String first, String second) {
        if (!first.equals(second)) {
            throw new RuntimeException("Failed to match " + first + " and " + second);
        }
    }

    public static List<String> tokenize(String str) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static String decode(String maskedString, String salt, int iterationCount) throws Exception {
        String PASS_MASK_PREFIX = "MASK-";
        String pbeAlgo = "PBEwithMD5andDES";
        if (maskedString.startsWith(PASS_MASK_PREFIX)) {
            String decodedValue;
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
            char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
            PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKey cipherKey = factory.generateSecret(keySpec);
            maskedString = maskedString.substring(PASS_MASK_PREFIX.length());
            maskedString = decodedValue = PBEUtils.decode64(maskedString, pbeAlgo, cipherKey, cipherSpec);
        }
        return maskedString;
    }
}

