/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.javaee;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RunAs;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.SecurityRoleRef;
import org.jboss.security.plugins.javaee.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAuthorizationHelper
extends AbstractEJBAuthorizationHelper {
    protected static Logger log = Logger.getLogger(EJBAuthorizationHelper.class);

    public boolean authorize(String ejbName, Method ejbMethod, Principal ejbPrincipal, String invocationInterfaceString, CodeSource ejbCS, Subject callerSubject, RunAs callerRunAs, String contextID, RoleGroup methodRoles) {
        if (ejbName == null) {
            throw new IllegalArgumentException("ejbName is null");
        }
        if (ejbMethod == null) {
            throw new IllegalArgumentException("ejbMethod is null");
        }
        if (ejbCS == null) {
            throw new IllegalArgumentException("EJB CodeSource is null");
        }
        if (contextID == null) {
            throw new IllegalArgumentException("ContextID is null");
        }
        if (callerSubject == null && callerRunAs == null) {
            throw new IllegalArgumentException("Either callerSubject or callerRunAs should be non-null");
        }
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw new IllegalStateException("Authorization Manager is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (this.policyRegistration == null) {
                this.policyRegistration = this.getPolicyRegistrationFromJNDI();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error getting Policy Registration", (Throwable)e);
        }
        map.put("policyRegistration", this.policyRegistration);
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setEjbVersion(this.version);
        ejbResource.setPolicyContextID(contextID);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setEjbName(ejbName);
        ejbResource.setEjbMethod(ejbMethod);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setEjbMethodInterface(invocationInterfaceString);
        ejbResource.setCodeSource(ejbCS);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setCallerSubject(callerSubject);
        ejbResource.setEjbMethodRoles(methodRoles);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, (CallbackHandler)sch);
        boolean isAuthorized = false;
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Error in authorization:", (Throwable)e);
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Subject callerSubject, String contextID, Set<SecurityRoleRef> securityRoleRefs) {
        return this.isCallerInRole(roleName, ejbName, ejbPrincipal, callerSubject, contextID, securityRoleRefs, false);
    }

    public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Subject callerSubject, String contextID, Set<SecurityRoleRef> securityRoleRefs, boolean enforceEJBRestrictions) {
        if (roleName == null) {
            throw new IllegalArgumentException("roleName is null");
        }
        if (ejbName == null) {
            throw new IllegalArgumentException("ejbName is null");
        }
        if (contextID == null) {
            throw new IllegalArgumentException("ContextID is null");
        }
        boolean isAuthorized = false;
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw new IllegalStateException("AuthorizationManager is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (this.policyRegistration == null) {
                this.policyRegistration = this.getPolicyRegistrationFromJNDI();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error getting Policy Registration", (Throwable)e);
        }
        map.put("policyRegistration", this.policyRegistration);
        map.put("roleName", roleName);
        map.put("roleRefPermissionCheck", Boolean.TRUE);
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setPolicyContextID(contextID);
        RunAs callerRunAs = SecurityActions.getIncomingRunAs(this.securityContext);
        ejbResource.setEjbVersion(this.version);
        ejbResource.setEjbName(ejbName);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setSecurityRoleReferences(securityRoleRefs);
        ejbResource.setEnforceEJBRestrictions(enforceEJBRestrictions);
        ejbResource.setCallerSubject(callerSubject);
        SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
        RoleGroup callerRoles = am.getSubjectRoles(callerSubject, (CallbackHandler)sch);
        try {
            int check = am.authorize((Resource)ejbResource, callerSubject, callerRoles);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            if (log.isTraceEnabled()) {
                log.trace((Object)(roleName + "::isCallerInRole check failed:" + e.getLocalizedMessage()), (Throwable)e);
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    public String getEJBVersion() {
        return this.version;
    }

    public void setEJBVersion(String ejbVersion) {
        if (!("1.1".equalsIgnoreCase(ejbVersion) || "2.0".equalsIgnoreCase(ejbVersion) || "3.0".equalsIgnoreCase(ejbVersion))) {
            throw new IllegalArgumentException("Invalid ejbVersion:" + ejbVersion);
        }
        this.version = ejbVersion;
    }

    private PolicyRegistration getPolicyRegistrationFromJNDI() throws Exception {
        return (PolicyRegistration)new InitialContext().lookup("java:/policyRegistration");
    }
}

