/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeDesignator;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeSelector;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.attr.BooleanAttribute;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.FunctionTypeException;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetMatch {
    public static final int SUBJECT = 0;
    public static final int RESOURCE = 1;
    public static final int ACTION = 2;
    public static final int ENVIRONMENT = 3;
    public static final String[] NAMES = new String[]{"Subject", "Resource", "Action", "Environment"};
    private int type;
    private Function function;
    private Evaluatable eval;
    private AttributeValue attrValue;

    public TargetMatch(int type, Function function, Evaluatable eval, AttributeValue attrValue) throws IllegalArgumentException {
        if (type != 0 && type != 1 && type != 2 && type != 3) {
            throw new IllegalArgumentException("Unknown TargetMatch type");
        }
        this.type = type;
        this.function = function;
        this.eval = eval;
        this.attrValue = attrValue;
    }

    public static TargetMatch getInstance(Node root, String prefix, String xpathVersion) throws ParsingException, IllegalArgumentException {
        int i;
        for (i = 0; i < NAMES.length && !NAMES[i].equals(prefix); ++i) {
        }
        if (i == NAMES.length) {
            throw new IllegalArgumentException("Unknown TargetMatch type");
        }
        return TargetMatch.getInstance(root, i, new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion));
    }

    public static TargetMatch getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        Function function;
        Evaluatable eval = null;
        AttributeValue attrValue = null;
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        String funcName = root.getAttributes().getNamedItem("MatchId").getNodeValue();
        FunctionFactory factory = FunctionFactory.getTargetInstance();
        try {
            URI funcId = new URI(funcName);
            function = factory.createFunction(funcId);
        }
        catch (URISyntaxException use) {
            throw new ParsingException("Error parsing TargetMatch", use);
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown MatchId", uie);
        }
        catch (FunctionTypeException fte) {
            try {
                URI funcId = new URI(funcName);
                function = factory.createAbstractFunction(funcId, root);
            }
            catch (Exception e) {
                throw new ParsingException("invalid abstract function", e);
            }
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = SunxacmlUtil.getNodeName(node);
            if (name.equals(NAMES[matchType] + "AttributeDesignator")) {
                eval = AttributeDesignator.getInstance(node, matchType, metaData);
                continue;
            }
            if (name.equals("AttributeSelector")) {
                eval = AttributeSelector.getInstance(node, metaData);
                continue;
            }
            if (!name.equals("AttributeValue")) continue;
            try {
                attrValue = attrFactory.createValue(node);
                continue;
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown Attribute Type", uie);
            }
        }
        ArrayList<Evaluatable> inputs = new ArrayList<Evaluatable>();
        inputs.add(attrValue);
        inputs.add(eval);
        function.checkInputsNoBag(inputs);
        return new TargetMatch(matchType, function, eval, attrValue);
    }

    public int getType() {
        return this.type;
    }

    public Function getMatchFunction() {
        return this.function;
    }

    public AttributeValue getMatchValue() {
        return this.attrValue;
    }

    public Evaluatable getMatchEvaluatable() {
        return this.eval;
    }

    public MatchResult match(EvaluationCtx context) {
        EvaluationResult result = this.eval.evaluate(context);
        if (result.indeterminate()) {
            return new MatchResult(2, result.getStatus());
        }
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        if (!bag.isEmpty()) {
            Iterator it = bag.iterator();
            boolean atLeastOneError = false;
            Status firstIndeterminateStatus = null;
            while (it.hasNext()) {
                ArrayList<AttributeValue> inputs = new ArrayList<AttributeValue>();
                inputs.add(this.attrValue);
                inputs.add((AttributeValue)it.next());
                MatchResult match = this.evaluateMatch(inputs, context);
                if (match.getResult() == 0) {
                    return match;
                }
                if (match.getResult() != 2) continue;
                atLeastOneError = true;
                if (firstIndeterminateStatus != null) continue;
                firstIndeterminateStatus = match.getStatus();
            }
            if (atLeastOneError) {
                return new MatchResult(2, firstIndeterminateStatus);
            }
            return new MatchResult(1);
        }
        return new MatchResult(1);
    }

    private MatchResult evaluateMatch(List inputs, EvaluationCtx context) {
        EvaluationResult result = this.function.evaluate(inputs, context);
        if (result.indeterminate()) {
            return new MatchResult(2, result.getStatus());
        }
        BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
        if (bool.getValue()) {
            return new MatchResult(0);
        }
        return new MatchResult(1);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String tagName = NAMES[this.type] + "Match";
        out.println(indent + "<" + tagName + " MatchId=\"" + this.function.getIdentifier().toString() + "\">");
        indenter.in();
        this.attrValue.encode(output, indenter);
        this.eval.encode(output, indenter);
        indenter.out();
        out.println(indent + "</" + tagName + ">");
    }
}

