/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DoubleAttribute;
import org.jboss.security.xacml.sunxacml.attr.IntegerAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.FunctionBase;

public class MultiplyFunction
extends FunctionBase {
    public static final String NAME_INTEGER_MULTIPLY = "urn:oasis:names:tc:xacml:1.0:function:integer-multiply";
    public static final String NAME_DOUBLE_MULTIPLY = "urn:oasis:names:tc:xacml:1.0:function:double-multiply";
    private static final int ID_INTEGER_MULTIPLY = 0;
    private static final int ID_DOUBLE_MULTIPLY = 1;

    public MultiplyFunction(String functionName) {
        super(functionName, MultiplyFunction.getId(functionName), MultiplyFunction.getArgumentType(functionName), false, 2, MultiplyFunction.getArgumentType(functionName), false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_INTEGER_MULTIPLY)) {
            return 0;
        }
        if (functionName.equals(NAME_DOUBLE_MULTIPLY)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown multiply function " + functionName);
    }

    private static String getArgumentType(String functionName) {
        if (functionName.equals(NAME_INTEGER_MULTIPLY)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_INTEGER_MULTIPLY);
        set.add(NAME_DOUBLE_MULTIPLY);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long arg0 = ((IntegerAttribute)argValues[0]).getValue();
                long arg1 = ((IntegerAttribute)argValues[1]).getValue();
                long product = arg0 * arg1;
                result = new EvaluationResult(new IntegerAttribute(product));
                break;
            }
            case 1: {
                double arg0 = ((DoubleAttribute)argValues[0]).getValue();
                double arg1 = ((DoubleAttribute)argValues[1]).getValue();
                double product = arg0 * arg1;
                result = new EvaluationResult(new DoubleAttribute(product));
                break;
            }
        }
        return result;
    }
}

