/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.xacml.existdb;

/**
 * Some constants for ExistDB Integration
 * @author Anil.Saldhana@redhat.com
 * @since Mar 24, 2010
 */
public interface ExistDBConstants
{
   // Key for configuring the collection name
   String COLLECTION_NAME_KEY = "collectionName";
   
   //Key for configuring the document name
   String DOCUMENT_NAME_KEY = "documentName";
   
   //Key for configuring a comma separated document names
   String NAMES_OF_DOCUMENTS_KEY = "namesOfDocuments";
   
   //Key for configuring the database url
   String DATABASE_URL = "databaseURL"; 
   
   //Key for configuring the user name
   String USERNAME_KEY = "userName";
   
   //Key for configuring the password
   String PASSWORD_KEY = "password";
   
   //Key to indicate the file where the xquery is stored
   String XQUERY_KEY = "xqueryFile";
}