/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.xacml.existdb.locators.attrib;

import java.io.File;
import java.util.List;

import org.jboss.security.xacml.existdb.ExistDBConstants;
import org.jboss.security.xacml.existdb.ExistSecurityCtx;
import org.jboss.security.xacml.existdb.util.ExistDBUtil;
import org.jboss.security.xacml.jaxb.Option;
import org.xmldb.api.base.Collection;

/**
 * Static class that contains the common code for all the attribute locators for Exist DB
 * @author Anil.Saldhana@redhat.com
 * @since Mar 25, 2010
 */
public class ExistAttributeLocatorsUtil
{
   /**
    * Process the XQuery file and return back the attribute value
    * @param options
    * @param className
    * @return
    */
   public static Object processXQuery(List<Option> options, String className)
   {
      String uri = ExistDBUtil.getOptionValue(options,ExistDBConstants.DATABASE_URL);
      if(uri == null)
         throw new RuntimeException("database url not configured");
      
      String collectionName = ExistDBUtil.getOptionValue(options,ExistDBConstants.COLLECTION_NAME_KEY);
      
      if(collectionName == null)
         collectionName = "xacml";   
      
      String documentName = ExistDBUtil.getOptionValue(options,ExistDBConstants.DOCUMENT_NAME_KEY);
      if(documentName == null)
         throw new RuntimeException("documentName not configured in " + className);
      
      String userName = ExistDBUtil.getOptionValue(options,ExistDBConstants.USERNAME_KEY);
      String pass = ExistDBUtil.getOptionValue(options,ExistDBConstants.PASSWORD_KEY); 
      
      String xqueryFileName = ExistDBUtil.getOptionValue(options,ExistDBConstants.XQUERY_KEY);
      if(xqueryFileName == null)
         throw new RuntimeException("xquery file name missing");

      String xquery = ExistDBUtil.readStaticFileIntoString(new File(xqueryFileName));
      try
      {
         Collection collection = null;
         
         if(userName == null || userName != "")
            collection = ExistDBUtil.getCollection(uri, collectionName, null);
         else
            collection = ExistDBUtil.getCollection(uri, collectionName, new ExistSecurityCtx(userName, pass));
         
         return ExistDBUtil.query(collection, xquery);
      }
      catch(Exception e)
      {
         throw new RuntimeException(e);
      } 
   }
}