/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.xacml.existdb.locators.policy;

import java.io.InputStream;
import java.util.List;
import java.util.Set;

import org.jboss.security.xacml.bridge.WrapperPolicyFinderModule;
import org.jboss.security.xacml.core.JBossXACMLPolicy;
import org.jboss.security.xacml.interfaces.XACMLConstants;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;

/**
 * A {@code AbstractLocator} that retrieves xacml policy from Exist DB
 * @author Anil.Saldhana@redhat.com
 * @since Mar 24, 2010
 */
public class ExistPolicyLocator extends ExistPolicySetLocator
{  
   public ExistPolicyLocator()
   {
      super(); 
   }

   public ExistPolicyLocator(Set<XACMLPolicy> policies)
   {
      super(policies); 
   }

   
   @SuppressWarnings("unchecked")
   @Override
   public void setPolicies(Set<XACMLPolicy> policies)
   {
      super.setPolicies(policies);
      
      this.policies = policies;
      
      List<PolicyFinderModule> finders = (List<PolicyFinderModule>) map.get(XACMLConstants.POLICY_FINDER_MODULE);
       
      
      for (XACMLPolicy xp : policies)
      {
         if (xp.getType() == XACMLPolicy.POLICY)
         {
            WrapperPolicyFinderModule pfm = new WrapperPolicyFinderModule((Policy) xp.get(XACMLConstants.UNDERLYING_POLICY));
            finders.add(pfm);
         }
      } 
   }

   @Override
   protected XACMLPolicy createPolicy(InputStream is) throws Exception
   {
      return new JBossXACMLPolicy(is, XACMLPolicy.POLICY);
   } 
}