/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.existdb.locators.policy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.security.xacml.bridge.PolicySetFinderModule;
import org.jboss.security.xacml.existdb.ExistSecurityCtx;
import org.jboss.security.xacml.existdb.util.ExistDBUtil;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.locators.JBossPolicySetLocator;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistPolicySetLocator
extends JBossPolicySetLocator {
    public ExistPolicySetLocator() {
        PolicySetFinderModule finderModule = new PolicySetFinderModule();
        ArrayList<PolicySetFinderModule> finders = new ArrayList<PolicySetFinderModule>();
        finders.add(finderModule);
        this.set("policy_finder_module", finders);
    }

    public ExistPolicySetLocator(Set<XACMLPolicy> policies) {
        super(policies);
    }

    public void setOptions(List<Option> theoptions) {
        super.setOptions(theoptions);
        Set<XACMLPolicy> policies = this.getPolicies();
        this.setPolicies(policies);
    }

    public Set<XACMLPolicy> getPolicies() {
        HashSet<XACMLPolicy> policies = new HashSet<XACMLPolicy>();
        String uri = ExistDBUtil.getOptionValue(this.options, "databaseURL");
        if (uri == null) {
            throw new RuntimeException("database url not configured");
        }
        String collectionName = ExistDBUtil.getOptionValue(this.options, "collectionName");
        if (collectionName == null) {
            collectionName = "xacml";
        }
        String documentName = ExistDBUtil.getOptionValue(this.options, "documentName");
        String namesOfDocuments = ExistDBUtil.getOptionValue(this.options, "namesOfDocuments");
        if (documentName == null && namesOfDocuments == null) {
            throw new RuntimeException("documentName or namesofDocuments not configured in the ExistPolicySetLocator");
        }
        String userName = ExistDBUtil.getOptionValue(this.options, "userName");
        String pass = ExistDBUtil.getOptionValue(this.options, "password");
        try {
            Collection collection = null;
            collection = userName == null || userName != "" ? ExistDBUtil.getCollection(uri, collectionName, null) : ExistDBUtil.getCollection(uri, collectionName, new ExistSecurityCtx(userName, pass));
            if (namesOfDocuments != null) {
                String[] docNames;
                for (String docName : docNames = this.getTokens(namesOfDocuments)) {
                    String policy = ExistDBUtil.retrieve(collection, docName);
                    ByteArrayInputStream bis = new ByteArrayInputStream(policy.getBytes("UTF-8"));
                    XACMLPolicy xacmlPolicySet = this.createPolicy(bis);
                    policies.add(xacmlPolicySet);
                }
            } else {
                String policy = ExistDBUtil.retrieve(collection, documentName);
                ByteArrayInputStream bis = new ByteArrayInputStream(policy.getBytes("UTF-8"));
                XACMLPolicy xacmlPolicySet = this.createPolicy(bis);
                policies.add(xacmlPolicySet);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return policies;
    }

    protected XACMLPolicy createPolicy(InputStream is) throws Exception {
        return PolicyFactory.createPolicySet((InputStream)is);
    }

    private String[] getTokens(String csv) {
        ArrayList<String> alist = new ArrayList<String>();
        if (csv == null) {
            throw new IllegalArgumentException("csv is null");
        }
        StringTokenizer st = new StringTokenizer(csv, ",");
        if (st != null) {
            while (st.hasMoreTokens()) {
                alist.add(st.nextToken());
            }
        }
        String[] strArr = new String[alist.size()];
        alist.toArray(strArr);
        return strArr;
    }

    static {
        try {
            String driver = "org.exist.xmldb.DatabaseImpl";
            Class<?> cl = Class.forName(driver);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing the ExistDB Drivers:", e);
        }
    }
}

